//**************************************************************//
//  Effect File exported by RenderMonkey 1.6
//
//  - Although many improvements were made to RenderMonkey FX  
//    file export, there are still situations that may cause   
//    compilation problems once the file is exported, such as  
//    occasional naming conflicts for methods, since FX format 
//    does not support any notions of name spaces. You need to 
//    try to create workspaces in such a way as to minimize    
//    potential naming conflicts on export.                    
//    
//  - Note that to minimize resulting name collisions in the FX 
//    file, RenderMonkey will mangle names for passes, shaders  
//    and function names as necessary to reduce name conflicts. 
//**************************************************************//

//--------------------------------------------------------------//
// Fabric Effects
//--------------------------------------------------------------//
//--------------------------------------------------------------//
// main
//--------------------------------------------------------------//
//--------------------------------------------------------------//
// Single Pass
//--------------------------------------------------------------//
string Fabric_Effects_main_Single_Pass_texture1 : ModelData = "..\\..\\..\\..\\..\\oma\\alt\\pallo_o.3DS";

float4x4 view_proj_matrix : WorldViewProjection;
//float4x4 view_proj_matrix : ViewProjection;
float scale
<
   string UIName = "scale";
   string UIWidget = "Numeric";
   bool UIVisible =  true;
   float UIMin = 0.00;
   float UIMax = 0.10;
> = float( 0.03 );
float4x4 view_matrix : View;
struct VS_OUTPUT {
   float4 Pos:     POSITION;
   float3 pos:     TEXCOORD0;
   float3 normal:  TEXCOORD1;
   float3 viewVec: TEXCOORD2;
   float3 normalO:   TEXCOORD3;
};

VS_OUTPUT Fabric_Effects_main_Single_Pass_Vertex_Shader_main(
         float4 Pos: POSITION, 
         float3 normal: NORMAL
         )
{
   VS_OUTPUT Out;

   Out.Pos = mul( Pos, view_proj_matrix );
   // Pass position to fragment shader
   Out.pos = Pos.xyz * scale;
   // Eye-soace lighting
   Out.normal = mul(normal, view_matrix );
   Out.viewVec = -mul(Pos, view_matrix );
   Out.normalO = normal;

   return Out;
}









float4 color;
float4 lightDir;
float furriness;
float noiseScale;
float sheen;
texture EarthClouds_Tex
<
   string ResourceName = "..\\..\\..\\..\\..\\oma\\alt\\noilch.dds";
>;
sampler Texture = sampler_state
{
   Texture = (EarthClouds_Tex);
   ADDRESSU = WRAP;
   ADDRESSV = WRAP;
   ADDRESSW = WRAP;
   MAGFILTER = LINEAR;
   MINFILTER = LINEAR;
   MIPFILTER = LINEAR;
};
// Returns a 3d grid pattern
float pattern(float3 pos, float freq){
   float3 fp = frac(pos * freq);
   fp *= (1 - fp);
   return dot(fp, 1);
}

float4 Fabric_Effects_main_Single_Pass_Pixel_Shader_main(
      float3 pos: TEXCOORD0,
      float3 normal: TEXCOORD1,
      float3 viewVec: TEXCOORD2,
      float3 normalO:   TEXCOORD3
      ) : COLOR 
{

   float3 nview = normalize(viewVec);
   float d = dot( normal, nview );
   float G1 = cos( d * 1.5708 );
//   float G2 = G1*G1;//
   float G2 = 1-(sin( d * 3.1415 - 1.5708 )+1)/2.0F;
   float G3 = ((sin( d + 1.5708 )))*2;
//   G3 = 1-sqrt(G3);
   
   float alp = 1;
   float3 col = tex2D( Texture, normal*(G2)/1.5f );
   float3 alphac = normal * G1;//sqrt(G/20.0f) ;
   
   float3 n_ = abs(normal * d);
   
   float3 tc = (normal);
   
   col = tex2D( Texture, tc*G1*G1 +float3(0.5,0.5,0.5) );

   float l = length( tc.xy );
/*   G2 = clamp( (G1-0.8), 0.5, 1 );
   tc.x = clamp( tc.x, -G2, G2 );
   tc.y = clamp( tc.y, -G2, G2 );
   tc.z = clamp( tc.z, -G2, G2 );*/
//   tc = atan(tc);
//   tc *= G1;
//   l = 1-clamp( l, 0, 1 );
   tc = (tc/l);// + (tc);
//   tc += normalO;
//   tc *= (1-G1);
   tc += float3(0.5,0.5,0.5);
   col = tex2D( Texture, tc );
   tc = normal;
   float3 col2 = tex2D( Texture, tc );
//   col = tex2D( Texture, (normal*(1-G)) + float3(0.5,0.5,0.5) );
   return float4( col.xxx*col2.x*G1, 1-G2 );
//float gr = (n_.x+n_.y+n_.z);
//   return float4( col.xxx*(2-G3), 1 );   
//   return float4( col.xxx/*G3*/*(1-G2), (G3)*(col.x) );
//   return float4( tex2D( Texture, G.xx *10 ).xyz * G.xxx, alp );// * G.xxx, alp );

}




//--------------------------------------------------------------//
// Technique Section for Fabric Effects
//--------------------------------------------------------------//
technique main
{
   pass Single_Pass
   {
      CULLMODE = CCW;
      ALPHABLENDENABLE = TRUE;
      DESTBLEND = INVSRCALPHA;
      SRCBLEND = SRCALPHA;

      VertexShader = compile vs_1_1 Fabric_Effects_main_Single_Pass_Vertex_Shader_main();
      PixelShader = compile ps_2_0 Fabric_Effects_main_Single_Pass_Pixel_Shader_main();
   }

}

