
//#include <include\\Quad.fxh>

float Script : STANDARDSGLOBAL <
	string UIWidget = "none";
	string ScriptClass = "scene";
	string ScriptOrder = "postprocess";
	string ScriptOutput = "color";
	string Script = "Technique=bc;";
> = 0.8; // version #

float4x4 worldViewProj : WorldViewProjection;

float brightness
<
	string UIName = "Brightness";
	string UIWidget= "slider";
	float UIMin = -1.0;
	float UIMax =  1.0;
	float UIStep = 0.05;
> = 0.0;

float contrast
<
	string UIName = "Contrast";
	string UIWidget= "slider";
	float UIMin =  0.0;
	float UIMax = 50.0;
	float UIStep = 0.1;
> = 8.5f;


texture effectTexture : RENDERCOLORTARGET
<
	float2 ViewPortRatio = { 1.0, 1.0f };
	string Format = "X8R8G8B8";
	string UIWidget = "None";
	int MipLevels = 1;
> ;
sampler effectSampler = sampler_state { 
    texture = <effectTexture>; 
    AddressU  = CLAMP; 
    AddressV = CLAMP; 
    MipFilter = POINT;
    MinFilter = LINEAR; 
    MagFilter = LINEAR; 
};

struct VS_IN
{
	float4 pos 	: POSITION;
	float3 nor	: NORMAL;
	float2 tex1	: TEXCOORD0;
} ;

struct VS_OUT
{
	float4 pos : POSITION;
	float3 nor : TEXCOORD0;
	float2 tex : TEXCOORD1;
} ;

VS_OUT VS(VS_IN inp)
{
	VS_OUT ret;
	ret.pos = mul ( inp.pos, worldViewProj );
//	ret.pos = inp.pos;
	ret.nor = inp.nor;
	ret.tex = inp.tex1;
	
	return ret;
}

float sigmoid ( float t, float contrast, float brightness )
{
	return (1.0 / ( 1 + pow ( 2.718, - (t - 0.5 + brightness) * contrast )  ));
}

float4 PS ( VS_OUT inp ) : COLOR
{
	float4 vari = tex2D(effectSampler, inp.tex);
	
	vari.r = sigmoid( vari.r, contrast, brightness );
	vari.g = sigmoid( vari.g, contrast, brightness );
	vari.b = sigmoid( vari.b, contrast, brightness );

	return vari;
}

technique bc
<
	string ScriptClass = "scene";
	string ScriptOrder = "postprocess";
	string ScriptOutput = "color";
	string Script =
			"RenderColorTarget0=effectTexture;"
//        	"ClearSetColor={0,0,0,1};"
			"Clear=Color;"
	       	"ScriptExternal=color;"
        	"Pass=p0;";
>
{
    pass p0
    <
		string ScriptClass = "scene";
		string ScriptOrder = "postprocess";
		string ScriptOutput = "color";
    	string Script = "RenderColorTarget0=;"
						"Draw=Buffer;";
    >
    {		
		cullmode = none;
		ZEnable = false;
		ZWriteEnable = false;
		AlphaBlendEnable = false;
		
		VertexShader = compile vs_2_0 VS();
		PixelShader  = compile ps_2_0 PS();
    }
}
