float4x4 matWorldViewProjection; 

#define texel = 1.f/512.f;
float2 Offsets[15];
float  Weights[15]; 

texture tex2;  //a
texture tex1;  //b
texture tex0;  //alpha
float alpha = 1.f; //pass1

sampler2D a = 
sampler_state
{
	texture = (tex2);
	MipFilter = Linear;
	MagFilter = Linear;
	MinFilter = Linear;
	
	AddressU = Clamp;
	AddressV = Clamp;
};

sampler2D b = 
sampler_state
{
	texture = (tex1);
	MipFilter = Linear;
	MagFilter = Linear;
	MinFilter = Linear; 
	
	AddressU = Clamp;
	AddressV = Clamp;
};

sampler2D Alpha = 
sampler_state
{
	texture = (tex0);
	MipFilter = Linear;
	MagFilter = Linear;
	MinFilter = Linear; 
	AddressV = Wrap; AddressU = Wrap;
};

void vs_texture(in float4 ipos : POSITION,
			    in float2 itex : TEXCOORD0,
			    out float4 opos : POSITION,
			    out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex; 
	otex.y += 1.f;
}

float4 ps_texture(in float2 tex : TEXCOORD0) : COLOR0
{
	return tex2D(Alpha, tex);
}

float4 ps_texture2(in float2 tex : TEXCOORD0) : COLOR0
{
	return tex2D(Alpha, tex)*alpha;
}

float4 ps_alphablendtexture(in float2 tex : TEXCOORD0) : COLOR0
{
	float  pixelalpha = saturate(tex2D(Alpha, tex));
	float4 pixela = tex2D(a, tex) * (pixelalpha);
	float4 pixelb = tex2D(b, tex) * (1.f-pixelalpha); 
	return pixela+pixelb;	
}

technique Texture
{
	pass p0
	{
		VertexShader = compile vs_2_0 vs_texture();
		PixelShader  = compile ps_2_0 ps_texture(); 
	}
	
	//Blur Pass 
	//offsets and Weights
	pass p1
	{
		VertexShader = compile vs_2_0 vs_texture();
		PixelShader  = compile ps_2_0 ps_texture2();
	}
	
	//alphablend via texture
	pass p2
	{
		VertexShader = compile vs_2_0 vs_texture();
		PixelShader  = compile ps_2_0 ps_alphablendtexture();
	}
}
