#include "zft.h"
#include <glib.h>

/* this file contains states that the tool can be in */
static EditState edit_state = NONE;
static LOState LO_state = LO_TREE;

static float trigger_time;
static int   spawn_number = 1;

/**
* Sets the flux edit state. This will affect the response that occurs when the
* drawing area of a zft_viewer clicked.
*
* \param input_edit_state state to set to
**/
void
zft_set_edit_state(EditState input_edit_state)
{
    edit_state = input_edit_state;
}

/**
* Returns the flux edit state. 
*
* \return the current flux edit state 
**/
EditState
zft_get_edit_state()
{
    return edit_state;
}

void
zft_set_LO_state(LOState input_LO_state)
{
    LO_state = input_LO_state;
}

LOState
zft_get_LO_state()
{
    return LO_state;
}

/**
* Sets the current trigger time from that a spawn point will spawn enemies at.
*
* \param input_trigger_time flux time when an enemy will spawn
**/
void
zft_set_trigger_time(float input_trigger_time)
{
    trigger_time = input_trigger_time;
}

/**
* Returns the current trigger time from that a spawn point will spawn enemies at.
*
* \return flux time when an enemy will spawn
**/
float
zft_get_trigger_time()
{
    return trigger_time;
}

/**
* Sets the current number of enemies that will spawn at a point.
*
* \param input_number number of enemies that will spawn at a point
**/
void
zft_set_spawn_number(int input_number)
{
   spawn_number = input_number; 
}   

/**
* Returns the current number of enemies that will spawn at a point.
*
* \return current number of enemies that will spawn at a point.
**/
int
zft_get_spawn_number()
{
    return spawn_number;
}   
