#ifndef ZFT_H

#define ZFT_H

#include "../include/zf.h"

#include <gtk/gtktable.h>

typedef enum{NONE, ADD_FLUX_REPEATER, ADD_HEX_FLUX_FIELD, ADD_FLUX_RING, ADD_BATTERY_RING, ADD_TIER_RING, ADD_HIVE, ADD_LANDSCAPE_OBJECT, ADD_TURRET, ADD_DROID, ADD_EEL, ADD_LEECH, ADD_DRONE, ADD_HUD_MESSAGE, REMOVE} EditState;

typedef enum{LO_TREE, LO_DOME, LO_BUILDING} LOState;

/**
* Sets the flux edit state. This will affect the response that occurs when the
* drawing area of a zft_viewer clicked.
*
* \param input_flux_edit_state state to set to
**/
void
zft_set_edit_state(EditState edit_state);

/**
* Returns the flux edit state. 
*
* \return the current flux edit state 
**/
EditState
zft_get_edit_state();

void
zft_set_LO_state(LOState LO_state);
LOState
zft_get_LO_state();


/**
* Sets the current trigger time from that a spawn point will spawn enemies at.
*
* \param input_trigger_time flux time when an enemy will spawn
**/
void
zft_set_trigger_time(float input_trigger_time);

/**
* Returns the current trigger time from that a spawn point will spawn enemies at.
*
* \return flux time when an enemy will spawn
**/
float
zft_get_trigger_time();

/**
* Sets the current number of enemies that will spawn at a point.
*
* \param input_number number of enemies that will spawn at a point
**/
void
zft_set_spawn_number(int input_number);

/**
* Returns the current number of enemies that will spawn at a point.
*
* \return current number of enemies that will spawn at a point.
**/
int
zft_get_spawn_number();

/**
* Creates a new viewer.
**/
GtkWidget*
zft_viewer_new(CLvertex camera_eye, CLvertex camera_center, CLvertex camera_up);

GList*
zft_viewer_get_droid_list(void);

GList*
zft_viewer_get_leech_list(void);

GList*
zft_viewer_get_eel_list(void);

GList*
zft_viewer_get_drone_list(void);

GList*
zft_viewer_get_fluxring_list(void);

GList*
zft_viewer_get_hexfluxfield_list(void);

GList*
zft_viewer_get_batteryring_list(void);

GList*
zft_viewer_get_tierring_list(void);

/**
* Creates a new toolbar.
**/
GtkWidget*
zft_toolbar_new();

#endif
