#include <zf.h>

#define WINDOW_WIDTH  800
#define WINDOW_HEIGHT 600

static void init_SDL(void)
{
    const SDL_VideoInfo* info;
  
    if (SDL_Init(SDL_INIT_VIDEO) < 0)
	exit(1);
  
    info = SDL_GetVideoInfo();
  
    if (!info)
	exit(1);
   
    SDL_GL_SetAttribute(SDL_GL_RED_SIZE, 5);
    SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE, 5);
    SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE, 5);
    SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 16);
    SDL_GL_SetAttribute(SDL_GL_STENCIL_SIZE, 1);
    SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);

  
    if (SDL_SetVideoMode(WINDOW_WIDTH, WINDOW_HEIGHT,
			 info->vfmt->BitsPerPixel,
			 SDL_OPENGL) == 0)
			 /* SDL_OPENGL | SDL_FULLSCREEN) == 0) */
	exit(1);
  
    SDL_WM_SetCaption("The Zyber: The Flux", 0);

    /*
      SDL_WM_GrabInput(SDL_GRAB_ON);
      SDL_ShowCursor(SDL_DISABLE);
    */
}

static void init_GL(void)
{
    glViewport(0, 0, WINDOW_WIDTH, WINDOW_HEIGHT);
}

static void close_SDL(void)
{
    SDL_Quit();
}

/* the "real stuff" */

static void
init(void)
{
    srand(time(0)); /* why not? */

    init_SDL();
    init_GL();

    clDisable(CL_VERBOSE);
    clioDisable(CLIO_VERBOSE);

    zf_audio_init();

    zf_menu_loop_init();  
    //zf_game_loop_init();
  
}

static void
close(void)
{
    zf_game_loop_close();  
    zf_menu_loop_close();
    zf_audio_close();
    close_SDL();
}

int
main(int argc, char* argv[])
{
    int menu_return = 1;
    // nickl - requiredto use glut primitives
    glutInit(&argc, argv);

    /* deal with command line parameters */
    argv++; argc--;

    while((argc > 0 ) && (argv[0][0] == '-'))
    {
	if (argv[0][1] == 'a')
	{
	    printf("command line argument found : (a) : disabling sound\n");
	    zf_audio_disable();
	}
	if (argv[0][1] == 'w')
	{
	    printf("command line argument found : (w) : disabling water\n");
	    zf_game_loop_set_water(false);
	}
	if (argv[0][1] == 'b')
	{
	    printf("command line argument found : (b) : enabling blur\n");
	    zf_game_loop_set_blur(true);
	}
	if (argv[0][1] == 's')
	{
	    printf("command line argument found : (s) : enabling super blur - NOTE this needs audio on\n");
	    zf_game_loop_set_super_blur(true);
	}
	if (argv[0][1] == 'c')
	{
	    printf("command line argument found : (b) : enabling cheat mode\n");
	    zf_game_loop_set_cheat_mode(true);
	}
	argv++; argc--;
    }

    init();

    while(menu_return)
    {
	menu_return = zf_menu_loop_run();

	if(menu_return)
	{
	    close();
	    init();
	}
    }
    /* doesn't quite work yet.... since the game_loop doesn't initially anything */
    //close();

    return 0;
}
