#include "../include/zf.h"

void
zf_text_draw(const char* text)
{
    char*        letter = (char*)text;
    unsigned int count  = 0;

    while(*letter != '\0')
    {
	//printf("count = %u\n", count);

	switch (*letter)
	{
	case ' ':
	    break;

	case '/':
	    glBegin(GL_LINES);	    
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glEnd();
	    break;

	case '%':
	    glBegin(GL_LINES);	    
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.3f, 1.0f, 0.0f);
	    glVertex3f(0.3f, 1.0f, 0.0f);
	    glVertex3f(0.3f, 0.7f, 0.0f);
	    glVertex3f(0.3f, 0.7f, 0.0f);
	    glVertex3f(0.0f, 0.7f, 0.0f);
	    glVertex3f(0.0f, 0.7f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.3f, 0.0f);
	    glVertex3f(1.0f, 0.3f, 0.0f);
	    glVertex3f(0.7f, 0.3f, 0.0f);
	    glVertex3f(0.7f, 0.3f, 0.0f);
	    glVertex3f(0.7f, 0.0f, 0.0f);
	    glVertex3f(0.7f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glEnd();
	    break;

	case '.':
	    glBegin(GL_LINES);	    
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(0.3f, 0.0f, 0.0f);
	    glEnd();
	    break;

	case '+':
	    glBegin(GL_LINES);	    
	    glVertex3f(0.5f, 0.6f, 0.0f);
	    glVertex3f(0.5f, 0.0f, 0.0f);
	    glVertex3f(0.2f, 0.3f, 0.0f);
	    glVertex3f(0.8f, 0.3f, 0.0f);
	    glEnd();
	    break;

	case '-':
	    glBegin(GL_LINES);	    
	    glVertex3f(0.2f, 0.5f, 0.0f);
	    glVertex3f(0.8f, 0.5f, 0.0f);
	    glEnd();
	    break;

	case '!':
	    glBegin(GL_LINES);	    
	    glVertex3f(0.5f, 1.0f, 0.0f);
	    glVertex3f(0.5f, 0.2f, 0.0f);
	    glVertex3f(0.35f, 0.0f, 0.0f);
	    glVertex3f(0.65f, 0.0f, 0.0f);
	    glEnd();
	    break;

	case ':':
	    glBegin(GL_LINES);
	    glVertex3f(1.0f, 0.8f, 0.0f);
	    glVertex3f(1.0f, 0.6f, 0.0f);
	    glVertex3f(1.0f, 0.4f, 0.0f);
	    glVertex3f(1.0f, 0.2f, 0.0f);
	    glEnd();
	    break;

	case '?':
	    glBegin(GL_LINES);	
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.8f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    glVertex3f(0.35f, 0.5f, 0.0f);
	    glVertex3f(0.35f, 0.5f, 0.0f);
	    glVertex3f(0.35f, 0.2f, 0.0f);
	    glVertex3f(0.20f, 0.0f, 0.0f);
	    glVertex3f(0.50f, 0.0f, 0.0f);
	    glEnd();
	    break;

	case '0':
	    glBegin(GL_LINES);	    
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    /* diagonal */
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glEnd();
	    break;

	case '1':
	    glBegin(GL_LINES);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glEnd();
	    break;

	case '2':
	    glBegin(GL_LINES);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glEnd();
	    break;

	case '3':
	    glBegin(GL_LINES);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    /* right */
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glEnd();
	    break;

	case '4':
	    glBegin(GL_LINES);
	    /* right */
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    /* centre */
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    /* left */
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glEnd();
	    break;

	case '5':
	    glBegin(GL_LINES);
	    /* top */
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    /* left top */
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    /* middle */
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    /* right bottom */
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    /* bottom */
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glEnd();
	    break;

	case '6':
	    glBegin(GL_LINES);
	    /* top */
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    /* left */
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    /* middle */
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    /* bottom */
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    /* right */
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);

	    glEnd();
	    break;

	case '7':
	    glBegin(GL_LINES);
	    /* top */
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);

	    /* right */
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glEnd();
	    break;

	case '8':
	    glBegin(GL_LINES);
	    /* top */
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    /* middle cross */
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    /* bottom */
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    /* left */
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    /* right */
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glEnd();
	    break;

	case '9':
	    glBegin(GL_LINES);
	    /* top */
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    /* middle cross */
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    /* bottom */
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    /* left */
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    /* right */
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glEnd();
	    break;

	case 'a':
	    glBegin(GL_LINES);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glEnd();
	    break;

	case 'b':
	    glBegin(GL_LINES);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);

	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);

	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);

	    glVertex3f(1.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);

	    glEnd();
	    break;

	case 'c':
	    glBegin(GL_LINES);	    
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glEnd();
	    break;

	case 'd':
	    glBegin(GL_LINES);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);

	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);

	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);

	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);

	    glEnd();
	    break;

	case 'e':
	    glBegin(GL_LINES);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glEnd();
	    break;

	case 'f':
	    glBegin(GL_LINES);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glEnd();
	    break;

	case 'g':
	    glBegin(GL_LINES);	    
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    glEnd();
	    break;

	case 'h':
	    glBegin(GL_LINES);	    
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glEnd();
	    break;

	case 'i':
	    glBegin(GL_LINES);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(0.5f, 1.0f, 0.0f);
	    glVertex3f(0.5f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glEnd();
	    break;

	case 'j':
	    glBegin(GL_LINES);
	    /* top */
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    /* bottom */
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    /* left */
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    /* right */
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glEnd();
	    break;

	case 'k':
	    glBegin(GL_LINES);
	    /* left */
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    /* top diag */
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    /* bottom diag */
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glEnd();
	    break;

	case 'l':
	    glBegin(GL_LINES);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glEnd();
	    break;

	case 'm':
	    glBegin(GL_LINES);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(0.5f, 1.0f, 0.0f);
	    glVertex3f(0.5f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glEnd();
	    break;

	case 'n':
	    glBegin(GL_LINES);	    
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glEnd();
	    break;

	case 'o':
	    glBegin(GL_LINES);	    
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glEnd();
	    break;

	case 'p':
	    glBegin(GL_LINES);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    glEnd();
	    break;
	    
	case 'q':
	    glBegin(GL_LINES);	    
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(0.5f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glEnd();
	    break;

	case 'r':
	    glBegin(GL_LINES);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glEnd();
	    break;

	case 's':
	    glBegin(GL_LINES);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glEnd();
	    break;

	case 't':
	    glBegin(GL_LINES);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(0.5f, 1.0f, 0.0f);
	    glVertex3f(0.5f, 0.0f, 0.0f);
	    glEnd();
	    break;

	case 'u':
	    glBegin(GL_LINES);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glEnd();
	    break;

	case 'v':
	    glBegin(GL_LINES);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.5f, 0.0f, 0.0f);
	    glVertex3f(0.5f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glEnd();
	    break;

	case 'w':
	    glBegin(GL_LINES);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(0.5f, 1.0f, 0.0f);
	    glVertex3f(0.5f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glEnd();
	    break;

	case 'y':
	    glBegin(GL_LINES);
	    /* bottom */
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    /* right */
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    /* centre */
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    /* left */
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glEnd();
	    break;

	case 'z':
	    glBegin(GL_LINES);	    
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glEnd();
	    break;

	case '_':
	    glBegin(GL_LINES);	    
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glEnd();
	    break;

	case '=':
	    glBegin(GL_LINES);	    
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 0.5f, 0.0f);
	    glVertex3f(1.0f, 0.5f, 0.0f);
	    glEnd();
	    break;

	default:
	    //printf("default (%c)\n", *letter);
	    
	    glBegin(GL_LINES);	    
	    glVertex3f(0.0f, 0.0f, 0.0f);
	    glVertex3f(1.0f, 1.0f, 0.0f);
	    glVertex3f(1.0f, 0.0f, 0.0f);
	    glVertex3f(0.0f, 1.0f, 0.0f);
	    glEnd();
	    break;
	}
	letter++;
	count++;
	
	glTranslatef(1.2f, 0.0f, 0.0f);
    }
}
