#include "../include/zf.h"


static int cross_hair_u; /* screen coordinates */
static int cross_hair_v;

static float cross_hair_size; /* percent of screen */

static CLtexture* reticule_texture;

static float rotate;

void
zf_cross_hair_render(void)
{
    GLfloat viewport[4];
    float aspect;
    float x, y;
    float size;

    glPushAttrib(GL_ALL_ATTRIB_BITS);

    glGetFloatv(GL_VIEWPORT, viewport);
    aspect = viewport[2] / viewport[3];

    x = (float)cross_hair_u / viewport[2];
    y = (float)cross_hair_v / viewport[3];

    x -= 0.5f;
    x *= 2.0f;
    y -= 0.5f;
    y *= 2.0f;
    size = cross_hair_size / 2.0f;


    glPushMatrix();
    glLoadIdentity();

    glMatrixMode(GL_PROJECTION);
    glPushMatrix();
    glLoadIdentity();

    glEnable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    clLoadTexture(reticule_texture);

    glColor4f(0.0f, 1.0f, 0.0f, 1.0f);

#if 0
      glTranslatef(x, -y, 0.0f);
      glRotatef(rotate, 0.0f, 0.0f, -1.0f);

  
      glBegin(GL_QUADS);
      glTexCoord2f(0.0f, 0.0f);
      glVertex2f( -size / aspect, -size);
      glTexCoord2f(0.0f, 1.0f);
      glVertex2f( -size / aspect,  size);
      glTexCoord2f(1.0f, 1.0f);
      glVertex2f(size / aspect,  size);
      glTexCoord2f(1.0f, 0.0f);
      glVertex2f( size / aspect, -size);
      glEnd();
      rotate += 1.0f;
#else
    glBegin(GL_QUADS);
    glTexCoord2f(0.0f, 0.0f);
    glVertex2f(x - size / aspect, -y - size);
    glTexCoord2f(0.0f, 1.0f);
    glVertex2f(x - size / aspect, -y + size);
    glTexCoord2f(1.0f, 1.0f);
    glVertex2f(x + size / aspect, -y + size);
    glTexCoord2f(1.0f, 0.0f);
    glVertex2f(x + size / aspect, -y - size);
    glEnd();
#endif
  
    glPopMatrix();

    glMatrixMode(GL_MODELVIEW);
    glPopMatrix();

    glPopAttrib();
}

void
zf_cross_hair_set_position(int u, int v)
{
    cross_hair_u = u;
    cross_hair_v = v;
}

void
zf_cross_hair_query_position_distance(CLvertex* position)
{
    GLdouble projection[16];
    GLdouble modelview[16];
    GLint viewport[4];
    GLdouble point[3];
    GLfloat distance;

    glGetDoublev(GL_PROJECTION_MATRIX, projection);
    glGetDoublev(GL_MODELVIEW_MATRIX, modelview);
    glGetIntegerv(GL_VIEWPORT, viewport);

/* HAXOR! should be viewport[3] - viewport[1] */
    glReadPixels(cross_hair_u, (double)viewport[3] - cross_hair_v,
		 1, 1, GL_DEPTH_COMPONENT, GL_FLOAT, &distance);

    gluUnProject((double)cross_hair_u, (double)viewport[3] - (double)cross_hair_v,
		 (double)distance,
		 modelview,
		 projection,
		 viewport,
		 &point[0], &point[1], &point[2]);
    
    cluSetVertex(position,
		 (float)point[0], (float)point[1], (float)point[2]);
}


/*
  STUFF FOR NEW ZF (THE ONE TRUE PATH!!!!... for code)
*/

/* this doesn't really do anything because there is only ever one instance! */

/* these will be the same for all singletons - maybe provide standard
   "empty" functions - MAYBE EVEN A STANDARD zf_static_smart_pointer!
   (OMFG!) */
static bool
is_valid(const void* nothing_to_see_here)
{
    return true;
}

static void
reference(void* nothing_to_see_here)
{
}

static void
release(void* nothing_to_see_here)
{
}
/* end of stuff we don't really need */

void
zf_cross_hair_init(void)
{ 
    //printf("%s()\n", __FUNCTION__);

    cross_hair_u = 0;
    cross_hair_v = 0;
    cross_hair_size = 0.1f; /* percent of screen */

    rotate = 0.0f;

    reticule_texture = clioLoadTexture("../data/textures/reticule/circle_reticule.png");
}

void
zf_cross_hair_close(void)
{
    /*clDeleteContext(context);*/
    clDeleteTexture(reticule_texture);
}
