#include <cl.h>
#include <clu.h>
#include <clio.h>

#include <GL/glut.h>

#include <libxml/encoding.h>
#include <libxml/xmlwriter.h>
#include <libxml/xmlreader.h>

#include <zf.h>

#define  LEVEL_DIR       "../data/level/"
#define  OUTPUT_FILENAME "../data/level/test.zfl"
#define  INPUT_FILENAME  "../data/level/test.zfl"

void level_write_file(ZfLevel* level, char* output_filename)
{	
    int rc;
    xmlTextWriterPtr writer;
    xmlChar *tmp;
    
    /* Create a new XmlWriter with no compression. */
    writer = xmlNewTextWriterFilename(output_filename, 0);
    if (writer == NULL)
    {
	printf("%s() : ERROR : creating the xml writer\n", __FUNCTION__);
	return;
    }
    
    /* Start the document with the xml default for the version,
     * encoding ISO 8859-1 and the default for the standalone
     * declaration. */
    rc = xmlTextWriterStartDocument(writer, NULL, "ISO-8859-1", NULL);
    if (rc < 0)
    {
	printf("%s(): ERROR : at xmlTextWriterStartDocument\n", __FUNCTION__);
	return;
    }
    
    /* Start an element named "EXAMPLE". Since thist is the first
     * element, this will be the root element of the document. */
    rc = xmlTextWriterStartElement(writer, BAD_CAST "EXAMPLE");
    if (rc < 0)
    {
	printf("%s() : ERROR : at xmlTextWriterStartElement\n", __FUNCTION__);
	return;
    }
    
    /* Here we could close the elements ORDER and EXAMPLE using the
     * function xmlTextWriterEndElement, but since we do not want to
     * write any other elements, we simply call xmlTextWriterEndDocument,
     * which will do all the work. */
    rc = xmlTextWriterEndDocument(writer);
    if (rc < 0)
    {
	printf("%s() : ERROR : at xmlTextWriterEndDocument\n", __FUNCTION__);
	return;
    }
    
    xmlFreeTextWriter(writer);
}

static void
processNode(xmlTextReaderPtr reader)
{
    const xmlChar *name, *value;
    
    name = xmlTextReaderConstName(reader);
    if (name == NULL)
	name = BAD_CAST "--";

    value = xmlTextReaderConstValue(reader);

    printf("%d %d %s %d %d", 
	    xmlTextReaderDepth(reader),
	    xmlTextReaderNodeType(reader),
	    name,
	    xmlTextReaderIsEmptyElement(reader),
	    xmlTextReaderHasValue(reader));
    if (value == NULL)
	printf("\n");
    else {
        if (xmlStrlen(value) > 40)
            printf(" %.40s...\n", value);
        else
	    printf(" %s\n", value);
    }
}

void level_read_file(ZfLevel* level, char* input_filename)
{
    xmlTextReaderPtr reader;
    int ret;
    
    reader = xmlReaderForFile(input_filename, NULL, 0);
    
    if (reader != NULL)
    {
        ret = xmlTextReaderRead(reader);
	
        while (ret == 1)
	{
            processNode(reader);
            ret = xmlTextReaderRead(reader);
        }
	
        xmlFreeTextReader(reader);
	
        if (ret != 0)
	{
            fprintf(stderr, "%s : failed to parse\n", input_filename);
        }
    }
    else
    {
        fprintf(stderr, "Unable to open %s\n", input_filename);
    }
}

int main(int argc, char** argv)
{
    char**       level_filenames;
    unsigned int num_filenames = 0;
    unsigned int i;

#if 0
    zf_level_search_directory(&level_filenames, &num_filenames, LEVEL_DIR);

    printf("printing filenames\n");
    for (i = 0 ; i < num_filenames ; i++)
    {
	printf("%u : %s\n", i, level_filenames[i]);
    }
#endif


    printf("writing test level to file %s\n", OUTPUT_FILENAME);
    {
	ZfLevel* level;

	level = zf_level_new();

	/* setup level */
	zf_level_set_skybox_file       (level, "../data/level/skybox.zf");
	zf_level_set_heightmap_file    (level, "../data/level/heightmap.zf");
	zf_level_set_flux_file         (level, "../data/level/flux.zf");
	zf_level_set_hives_file        (level, "../data/level/hives.zf");
	zf_level_set_wasps_file        (level, "../data/level/wasps.zf");
	zf_level_set_hexfluxfields_file(level, "../data/level/hexfluxfields.zf");
	zf_level_set_fluxrings_file    (level, "../data/level/fluxrings.zf");
	zf_level_set_batteryrings_file (level, "../data/level/batteryrings.zf");
	zf_level_set_tierrings_file    (level, "../data/level/tierrings.zf");
	zf_level_set_drones_file       (level, "../data/level/drones.zf");
	zf_level_set_droids_file       (level, "../data/level/droids.zf");
	zf_level_set_eels_file         (level, "../data/level/eels.zf");
	zf_level_set_hudmessages_file  (level, "../data/level/hudmessages_empty.zf");
	zf_level_set_landscape_file    (level, "../data/level/landscape.zf");

	zf_level_write_file(level, OUTPUT_FILENAME);
    }

#if 0    
    printf("read test level from file %s\n", INPUT_FILENAME);
    {
	ZfLevel* level;

	level_read_file(level, INPUT_FILENAME);
    }
#endif

    return 0;
}
