
uniform mat4 tmpMatrix;
uniform float maxEMP;
uniform float empAmt;

varying vec3 normal, lightDir, eyeVec;
varying vec4 projCoord;
varying float transparency;

void main()
{
	vec4 realPos = gl_ModelViewMatrix * gl_Vertex;
	
	normal = gl_NormalMatrix * gl_Normal;
	lightDir = vec3(gl_LightSource[0].position.xyz - realPos.xyz);
	eyeVec = -realPos.xyz;
	
	gl_TexCoord[0] = gl_MultiTexCoord0;
	
	vec3 pos;
	float unitFactor = 0.0;
	/*if(empAmt < unitFactor)
	{	// Shrink
		transparency = 0.5;
		pos = gl_Vertex.xyz - (gl_Normal.xyz * empAmt/unitFactor);
	}
	else*/
	//{	// Expand
		transparency = 1.0 - (empAmt/maxEMP);
		pos = gl_Vertex.xyz + (gl_Normal.xyz * (empAmt - unitFactor));
	//}
	
	projCoord = tmpMatrix * gl_ModelViewMatrix * vec4(pos,1.0);

	gl_Position = gl_ModelViewProjectionMatrix * vec4(pos, 1.0);
}
