
varying vec3 normal, lightDir, eyeVec;
uniform sampler2D tex;

void main (void)
{
    vec4 tex_color = texture2D(tex, gl_TexCoord[0].st);
	vec4 final_color = tex_color * gl_Color;
									
	vec3 N = normalize(normal);
	vec3 L = normalize(lightDir);
			
	float lambertTerm = dot(N,L);
			
	if(lambertTerm > 0.0)
	{
		final_color += tex_color * gl_LightSource[0].diffuse * gl_FrontMaterial.diffuse * lambertTerm;
	}
	
	gl_FragColor = final_color;			
}
