;
;  My tacky 256 byte Matrix effect.....
;

		org $2000-2            	; -2 since we have to include a LOAD address
		dw	$2000


Delay		equ	$02
Column		equ	$42
Row			equ	$82


ScreenBase	equ	$f7
TempColour	equ	$f8
TempRow		equ	$f9
TempChar	equ	$fa
LoopSize	equ	$fb
ColourAdd	equ	$fc
CharAdd		equ	$fe

AddressLo	equ	$c2	;$3100
AddressHi	equ	$3200
Char		equ	$3300
StreamLen	equ	$3400

MAXRUNS		equ	63


		;
		; On plus/4 reset and 1st SYS call.  A=0,X=7,Y=0,F=0  ($07f2-$07f5)
		; SYS command - $a7b5
		;

Start
		; ------------------------------------------------------------------
		; Start and INIT
		; ------------------------------------------------------------------
		sei						; We kill the machine...so disable IRQ's
		sta	$ff15				; Black screen
		sta	$ff19				; Black border
		sta	AddressLo
		sta	AddressHi			; point to colour screen

		ldx	#01
!MakeTable:
		clc						; create a screen xply lookup table
		lda	AddressLo-1,x		; Makes at LEAST a screen table worth (25 lines)
		adc	#40
		sta	AddressLo,x
		lda	AddressHi-1,x
		adc	#0
		sta	AddressHi,x


		; Make random stream lengths
		lda	$9313,x
		and	#7
		ora	#4					; MIN of 4 long...
		sta	StreamLen,x

		lda	$c711,x
		sta	Column,x
		and	#$1f				; Start Y location on screen
		sta	row,x

		jsr	NewColumn

		inx
		cpx	#MAXRUNS+1
		bne	!MakeTable

		lda	#8					; set the 1st screen to the default boot screen
		sta	ScreenBase


		; ------------------------------------------------------------------
		; Main loop
		; ------------------------------------------------------------------

MainLoop:
!lp2	ldx	$ff1d				; Execute a BIG delay so it minimises flicker as best we can
		bne	!lp2
		lda	ScreenBase			; Set current back buffer and front screen
		sta	$ff14
		eor	#$10				; Flip back buffer screen
		sta	ScreenBase


		; --------------------------------------------
		;
		; Clear the current back buffer
		;
		; --------------------------------------------
		;ldx	#$00			; is 0 from RASTER
		;lda	ScreenBase		; already holds screen base
		;ora	#4				; We'll fill colour ram instead

		; Small CLS routine - clears the COLOUR screen to hide chars, rather than the character screen
		sta	CharAdd+1			; Buffer HI = ScreenBase
		stx	CharAdd				; Buffer LO = 0
		txa						; set A to be BLACK	(since X=0)
!Cls2
		tay						; reset Y to 0
!Cls1
		sta	(CharAdd),y
		dey
		bne	!Cls1
		inc	CharAdd+1
		inx
		cpx	#4
		bne	!Cls2




		; --------------------------------------------
		;
		; Now process all streams
		;
		; --------------------------------------------
		ldx	#MAXRUNS


!RenderAllColumns:
		ldy	Row,x				; get current "Y" coord
		sty	TempRow
		lda	Char,x				;Get current base character
		sta	TempChar

		dec	Delay,x				; move + animate stream?
		bpl	!NoMove

		adc	$a441,x				; change stream characters in a random way
		and	#$3f				; keep it in the normal range (alphabet+numbers etc.)
		sta	Char,x

		lda	$a441,x				; Reset delay
		and	#3
		sta	Delay,x


		; Move stream down screen
		iny
		tya
		and	#$1f				; and wrap after 31 (whole stream is off screen here)
		sta	Row,x
		bne	!NoMove				; if NOT reset back to 0, then skip stream X movement

		jsr	NewColumn			; if moved off screen, move the stream to the right by a random(ish) amount
!NoMove


		; ---------------------------------------------------------
		;
		; Plot a vertical stream, changing the colour as it goes
		;
		; ---------------------------------------------------------
		lda	StreamLen,x			; get the length of the stream
		sta	LoopSize
		asl						; use the stream length as the basis for the shade as well
		asl
		asl
		asl
		ora	#5					; So shade of green depends on length
		sta	TempColour

!StreamLoop
		ldy	TempRow				; Get row...  (Y coord)
		cpy	#25					; if >25 then "clip"
		bcs	!DontDraw		

		lda	AddressLo,y			; Get X,Y in colour+screen address	 (NOT a zero page instruction!  lda $00xx,y)
		sta	ColourAdd
		sta	CharAdd
		lda	AddressHi,y
		ora	ScreenBase
		sta	ColourAdd+1
		ora	#$04				; Point to the character screen	
		sta	CharAdd+1

		ldy	Column,x			; get COLUMN  (X coord)
		lda	TempColour
		sta	(ColourAdd),y
		;sec
		sbc	#$0f				; Change colour (make darker)  $10-1 to take into account carry clear
		sta	TempColour
		lda	TempChar
		sta	(CharAdd),y




!DontDraw:
		inc	TempChar			; change character going UP the stream
		dec	TempRow				; Y = Y -1

		dec	LoopSize			; StreamLen = StreamLen-1
		bpl	!StreamLoop
		;
		; Plot END
		;

		dex
		bne	!RenderAllColumns



		;
		; Render the text "The Matrix has you"
		; (If we drop the text out the "matrix effect" comes in at 216 bytes)
		;
		ldx	#17
!lp1:
		lda	Text,x
		sta	$0d73+(40*2),x		; goes to both buffers at once to keep it small/simple
		sta	$1d73+(40*2),x
		lda	#$35
		sta	$0973+(40*2),x		; set dark green colour...
		sta	$1973+(40*2),x
		dex
		bpl	!lp1

		jmp	MainLoop


		; THE MATRIX HAS YOU - CBM text
Text:	db	$14,$08,$05,$20,$0d,$01,$14,$12,$09,$18,$20,$08,$01,$13,$20,$19,$0f,$15

;----------------------------------------------------------------------------
;
; Moves the column to the right to try an randomize it a little more
;
;----------------------------------------------------------------------------
NewColumn
		lda	$e812,x					; create a new random X coord so that the streams look constantly random
		and	#7
		adc	Column,x
		and	#$3f
		cmp	#40
		bcc	!Okay
		sbc	#40
!Okay:	sta	Column,x
		rts


EndCode:
	Message "EndSize=",(EndCode-Start)



