lines		= $C0		; any zeropage address
sin_move	= $B0		; any zeropage address
sin_mov2	= $B1		; any zeropage address 

sinus		= $2000

and_val1	= $3000		; AND values for left side
and_val2	= $3100		; AND values for right side
ora_val1	= $3200		; OR values for left side (actual bar graphics)
ora_val2	= $3300		; OR values for right side (actual bar graphics)
	
	LDX #$00
	LDA #$99		; multicolor
	STA $FF07
	JSR clear_screen_sync
	;
	;			; x=y=0 at this point
	;
kefr_i3	TYA
	AND #$06		; limit to 8 lines, throw away lowest bit
	TAX
	;
	LDA $D2F8,x		; the values we need: $FF,$3F,$0F,$03
	STA and_val2,y		; get it from ROM
	EOR #$FF
	STA and_val1,y
	;
	LDA ora_init,x		; OR values are mixed (1,3,5,7) and (2,4,6,8)
	STA ora_val1,y
	LDA ora_init+1,x
	STA ora_val2,y
	;
	TYA
	STA $0C00,y		; build char map
	;
	INY
	BNE kefr_i3
	;
	JSR erase_charset	; includes sync
	;
	SEC
	ROL $FF06		; screen on
	;
	; ---
	;
kefr_b0	LDY #$06		; sync to rasterline 6, then 5 (top of screen)
	JSR sync_2x
	;
	LDA #($C8/2)		; there's not enough time to draw it each line
	STA lines		; without an unrolled loop, so use half number of lines
	;
kefr_l0	LDA #$07		; 2
	STA $FF1D		; 4
	STA $FF1F		; 4 = 10
	;
;sin_move
	LDA sin_move
	ADC lines
	TAY
	;
;sin_mov2
	LDA sin_mov2
	ADC lines
	TAX
	;
	LDA sinus,y
	ADC sinus,x		
	TAX			; X = horizontal pos within char			
	AND #$F8		; (don't need AND #$07, because tables repeat)
	TAY			; Y = vertical pos (always top line within char)
	;
	LDA $6800,y		; 4 draw left side
	AND and_val1,x		; 4
	ORA ora_val1,x		; 4
	STA $6800,y		; 4
	;
	LDA $6808,y		; 4 draw right side
	AND and_val2,x		; 4
	ORA ora_val2,x		; 4
	STA $6808,y		; 4
	;
	JSR $D8A6		; 48 cycles delay; JSR+RTS = 12, 48-12 = 36 cycles needed
	;          
	DEC lines		; 2
	BNE kefr_l0		; 3 (taken)= 5 (should be 65 or 66 cycles)
	;
	JSR close_border	; close border, call player
	;
	; ---
	;
	INC sin_move;+1		; wave the effect
	INC sin_move;+1
	;
	INC sin_mov2;+1
	;
	JSR clear_6800_6900	; clear out whole set after each frame
	;
	INC timer
	BNE kefr_b0
;[eof]