;
; Petscii Plasma
; 128 byte demo
;              
; Written by Csabo of LOD 2007
;
DEBUG=0

 	ORG $100D - 2
 	DW  $100D
 	
ptr		= $C8	; fixed
ptr2		= $EA

lines		= $C4	; any zeropage address is ok
line_add	= $C5	; any zeropage address is ok
sinus_count_1	= $81	; any zeropage address is ok

cnt_lo		= $17	; assume value is $16 on init
cnt_hi		= $C0	; assume value is $00 on init  
add_value	= $C1	; assume value is $00 on init 

sinus		= $1100	; can go anywhere

	SEI
	;
	; ------------------------
	;  Generate "sinus" table
	;
	; really a parabola, but similar enough to a sinus
	; 
	PHA			; keep add value on stack
	DEY			; y=$FF, counts down
	;
loop	LDA cnt_lo
	ADC #$07
	STA cnt_lo
	BCC *+4
	INC add_value
	ADC cnt_hi
	STA cnt_hi
	;
	PLA
	ADC add_value
	PHA
	;
	STA sinus,x		; 1st segment
	STA sinus+$100,x	;     replicate 1st again, because plasma reads over the page boundary
	STA sinus,y		; 4th segment (same as 1 but backwards)
	EOR #$7F		;     two's complement (same as A=$7F-A)
	STA sinus+$80,x		; 3rd segment
	STA sinus-$80,y		; 2nd segment
	;
	DEY
	INX
	CPX #$40		; stop at 1/4
	BNE loop
	;
	STA $FF19		; gray background
	STA $FF15
	;        
	LDY #$0F		; mirror plasma chars
pl_i1	LDA plasma_chars-$40,x	; 12 bytes of code
	STA plasma_chars+$10,y	; saves 16 bytes of data
	INX
	DEY
	BPL pl_i1
	;
	; --------------
	;
main_loop	
	if DEBUG=1
	LDA $FF19
	EOR #$55
	STA $FF19  
	endif
	;
;	LDA #$CC
;plsync	CMP $FF1D		; sync (anywhere)
;	BNE plsync		; about the same effect without sync  
	;
	if DEBUG=1
	LDA $FF19
	EOR #$55
	STA $FF19
	endif
	;
	DEC sinus_count_1	; move the stuff...
	DEC sinus_count_1
	;         
	INC sin2+1
	;
	;---
	LDA #24			; number of lines
	STA lines
	;
pl4	;LAX lines 
	DB $A7			; LAX $00 opcode
	DB lines
	;
	;CLC			; do away with this CLC... less accurate but the difference is not noticable
	ADC sinus_count_1
	TAY 
	;
	TXA			; A = lines
	CLC
	ADC sinus,y
	STA line_add		; pre calculate Y value
	;
	JSR $D8AA		; X = lines, get screen position in $C8/C9
	;
	; --- main plasma loop
	;
	LDY #39			; control width
	;
pl3	LDA line_add		;      value for Y (pre calculated)
sin2	ADC sinus,y		; plus value for X = plasma!
	;   
	AND #$1F		; use a char lookup table (slower)
	TAX
	LDA plasma_chars,x
	STA (ptr),y 		; draw it
	;
	DEY
	BPL pl3
	;
	DEC lines
	;
	BPL pl4
	BMI main_loop		; always jump
	;
plasma_chars
	DB $41,$38,$18,$33,$24,$25,$14,$09
	DB $3C,$28,$2F,$63,$3B,$2C,$3A,$20
;[eof]