float4x4 matView;
float4x4 matViewProjection;
float mongo = 0.f;
float alphavalue = 1.f;

float  fadetoblack = 1.f;
float ParticleSize = 3.f;

texture tex0; //diffuse

sampler2D diffuse = 
sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Clamp; AddressV = Clamp;
};

sampler2D circle = 
sampler_state
{
	texture = (tex0);
	MipFilter = None; MagFilter = Linear; MinFilter = Linear;
	AddressU = Clamp; AddressV = Clamp;
};


void vs_partikkel(in float3 ipos : POSITION,
				  in float2 itex : TEXCOORD0,
				  in float3 normal : NORMAL,
				  out float4 opos : POSITION,
				  out float2 otex : TEXCOORD0,
				  out float2 otex2 : TEXCOORD1,
				  out float  inter : TEXCOORD2,
				  out float  fog : TEXCOORD3)
{
	float xcoord = 1.f/8.f;
	fog = 1.f-clamp((abs(ipos.z)/450.f), 0.f, 1.f);
	float factor = length(ipos.z+100.f);	
	float dude = 4.f+4.f*sin( (ipos.z*.7f)+normal.x);
	inter = frac(dude);
	int part = floor(dude);
	 
	ipos += (float3(matView._11, matView._21, matView._31)*itex.x)*ParticleSize;
	ipos += (float3(matView._12, matView._22, matView._32)*itex.y)*ParticleSize;
	opos = mul(float4(ipos, 1.f), matViewProjection);
	otex = itex + .5f;
	otex.y = 1.f-otex.y;
	otex2 = otex;
	
	float x = otex.x;
	otex.x = otex.x  * xcoord + (xcoord*part);
	otex2.x = x  * xcoord + (xcoord*(part+1));
}


float4 ps_partikkel(in float2 tex : TEXCOORD0,
					in float2 tex2: TEXCOORD1,
					in float inter : TEXCOORD2,
					in float fog : TEXCOORD3,
					in float2 alphatex : TEXCOORD4,
					in float3 alphatex2 : TEXCOORD5) : COLOR0
{
	float4 a = tex2D(diffuse, tex);
	float4 b = tex2D(diffuse, tex2);
	float4 p = lerp(a, b, inter);
	

	return p*fog;
}

/********************************************************************************************/


float4 ps_mongo(in float2 tex : TEXCOORD0) : COLOR0
{
	float4 a = tex2D(diffuse, tex);
	return float4(a.r ,a.r, a.r, a.r);
}

/******************************************************************************************/

void vs_circle(in float3 ipos : POSITION,
				 in float3 normal : NORMAL,
				 in float2 itex : TEXCOORD0,
				 out float4 opos : POSITION,
				 out float2 otex : TEXCOORD0)
{
	ipos += (float3(matView._11, matView._21, matView._31)*itex.x)*normal.x;
	ipos += (float3(matView._12, matView._22, matView._32)*itex.y)*normal.x;
	opos = mul(float4(ipos, 1.f), matViewProjection);
	
	otex = itex + .5f;
	otex.y = 1.f-otex.y;
}

float4 ps_circle(in float2 tex : TEXCOORD0) : COLOR0
{
	float4 a = tex2D(circle, tex);
	
	if(a.a==1.f)
		return a;
	else 
		return float4(0.f, 0.f, 0.f, 0.f);
}

/****************************************************************************************/

void vs_circlewhite(in float3 ipos : POSITION,
				 in float3 normal : NORMAL,
				 in float2 itex : TEXCOORD0,
				 out float4 opos : POSITION,
				 out float2 otex : TEXCOORD0)
{
	normal.x *= 1.1f;
	ipos += (float3(matView._11, matView._21, matView._31)*itex.x)* normal.x;
	ipos += (float3(matView._12, matView._22, matView._32)*itex.y)* normal.x;
	opos = mul(float4(ipos, 1.f), matViewProjection);
	
	otex = itex + .5f;
	otex.y = 1.f-otex.y;
}

float4 ps_circlewhite(in float2 tex : TEXCOORD0) : COLOR0
{
	float4 hore = tex2D(circle, tex);
	return float4(1.f, 1.f, 1.f, hore.a);
}

float4 ps_circlewhitea(in float2 tex : TEXCOORD0) : COLOR0
{
	float4 hore = tex2D(circle, tex);
	return float4(1.f, 1.f, 1.f, hore.a*mongo);
}
/**********************************************************************************************/
technique Partikkel
{
	pass diffuse
	{
		VertexShader = compile vs_2_0 vs_partikkel();
		PixelShader  = compile ps_2_0 ps_partikkel();
	}
	
	pass mongo
	{
		VertexShader = compile vs_2_0 vs_partikkel();
		PixelShader  = compile ps_2_0 ps_mongo();
	}
	
	pass circle 
	{
		VertexShader = compile vs_2_0 vs_circle();
		PixelShader  = compile ps_2_0 ps_circle();
	}
	
	pass circlewhite
	{
		VertexShader = compile vs_2_0 vs_circlewhite();
		PixelShader  = compile ps_2_0 ps_circlewhite();
	}
	
	pass circleAlpha
	{
		VertexShader = compile vs_2_0 vs_circlewhite();
		PixelShader  = compile ps_2_0 ps_circlewhitea();
	}
}