varying vec2 texCoord;
uniform sampler2D baseMap;
uniform sampler2D noiseMap;
uniform samplerCube envMap;

varying vec3 varyEyeVec;
varying vec3 varyTangent;
varying vec3 varyBiNormal;
varying vec3 varyNormal;
varying vec3 varyLight;
uniform float tresh;
varying vec3 spherePosV;
varying vec3 varyEyeVecMs;
void main()
{
	
	vec4 col = texture2D(baseMap,texCoord*1.1);
	vec3 bump = texture2D(noiseMap,texCoord*1.0);
	float lightRec = max(dot(normalize(varyLight),normalize(bump)),1.0);
	vec3 envCol = textureCube(envMap,reflect(normalize(varyEyeVec),normalize(bump))).rgb;
	float lumi = envCol.r/3.0 + envCol.b/3.0 + envCol.g/3.0;
	lumi = pow(lumi,2.0);
	float attenuation = length(varyEyeVec)*0.01;
	attenuation = 1.0/attenuation;
	attenuation = 1.0;
	gl_FragColor = vec4(vec3(lumi),1.0);
	gl_FragColor.a=0.5;

}