attribute vec3 normals;
attribute vec3 tangent;
attribute vec2 texCoord1;
attribute vec2 displace;
varying vec2 texCoords;


varying vec3 varyEyeVec;
varying vec3 varyTangent;
varying vec3 varyBiNormal;
varying vec3 varyNormal;
varying vec3 varyLight;
uniform float toSeed;
uniform float fromSeed;
uniform float seedT;

void main()
{
 float seed =fromSeed + (toSeed-fromSeed)*seedT;
 float dispExtra = length(displace)*0.009;
 vec3 seedS = vec3(seed + dispExtra*0.2*displace.x,seed + dispExtra*0.1,seed * dispExtra);
float nS= seed*150.3+ 30.0;
vec4 scaledV = vec4(cos(seedS.y*1.5+displace.x)*nS,
     sin(seedS.y*1.5+displace.x)*nS  ,
     cos(seedS.y*1.5 + displace.x + seed)*2.38*pow(dispExtra,3.4),0.0);
 vec4 transedV = vec4(gl_Vertex.xyz*15.0,gl_Vertex.w) + vec4(displace.x,660.0,displace.y,0.0) + scaledV;
//     gl_Position = ftransform();
 mat4 mat;
 mat[0] = vec4(1.0,0.0,0.0,0.0);
 mat[1] = vec4(0.0,-1.0,0.0,0.0);
 mat[2] = vec4(0.0,0.0,1.0,0.0);
 mat[3] = vec4(0.0,0.0,0.0,1.0);
 gl_Position = gl_ProjectionMatrix * gl_ModelViewMatrix * transedV;
 texCoords = texCoord1; 

 
 varyEyeVec = vec3(gl_ModelViewMatrix*transedV);
 varyNormal = normalize(gl_NormalMatrix*normals);
 varyTangent = normalize(gl_NormalMatrix*tangent);
 varyBiNormal = normalize(cross(varyNormal,varyTangent));
 
 varyLight = -varyEyeVec;
 
 //make eyeVec in tangent space.
 vec3 tempEye = varyEyeVec;
 varyEyeVec.x = dot( tempEye, varyTangent ); 
 varyEyeVec.y = dot( tempEye, varyBiNormal ); 
 varyEyeVec.z = dot( tempEye, varyNormal ); 
 
 vec3 tempLight = varyLight;
 varyLight.x = dot( tempLight, varyTangent ); 
 varyLight.y = dot( tempLight, varyBiNormal ); 
 varyLight.z = dot( tempLight, varyNormal ); 
 
}