uniform sampler2D texture;
uniform samplerCube envmap;
uniform sampler2D normy;
uniform float anim;


varying vec3 varyEyeVec;
varying vec3 varyNormal;
varying vec2 texCoords;

void main(void)
{
   //now use noiseColor to pertube normal.
   vec3 pertNormal = normalize(vec3(varyNormal));
   vec4 texCol = texture2D(texture,vec2(texCoords.x*4.0,texCoords.y*8.0));
   pertNormal = texture2D(normy,vec2(texCoords.x*2.0,texCoords.y*4.0 - anim)).rgb;
   vec4 envCol = textureCube(envmap,reflect(normalize(varyEyeVec),pertNormal)*1.0);
  float att = length(-varyEyeVec);
  att = 1.0/(att*0.0001);
  
  float glower =0.0;
  att = clamp(att,0.0,1.4);
  float mask = 0.3;// - texCol.a;
  
  gl_FragColor = (envCol*0.8*texCol) * vec4(1.8,1.8,1.9,1.0)*att* dot(normalize(-varyEyeVec),pertNormal);
//  gl_FragColor = vec4(1.0); 
}