attribute vec3 normals;
attribute vec3 tangent;
attribute vec2 texCoord1;
varying vec2 texCoord;


varying vec3 varyEyeVec;
varying vec3 varyTangent;
varying vec3 varyBiNormal;
varying vec3 varyNormal;
varying vec3 varyLight;
varying vec3 spherePosV;
varying vec3 varyEyeVecMs;
uniform vec3 spherePos;
void main()
{

 texCoord = texCoord1;
 gl_Position = ftransform();
 spherePosV = vec3(gl_ModelViewMatrix*vec4(spherePos,1.0));
 varyEyeVec = vec3(gl_ModelViewMatrix*gl_Vertex);
 varyEyeVecMs = varyEyeVec;
 varyNormal = normalize(gl_NormalMatrix*normals);
 varyTangent = normalize(gl_NormalMatrix*tangent);
 varyBiNormal = normalize(cross(varyNormal,varyTangent));
 
 varyLight = -varyEyeVec;
 
 //make eyeVec in tangent space.
 vec3 tempEye = varyEyeVec;
 varyEyeVec.x = dot( tempEye, varyTangent ); 
 varyEyeVec.y = dot( tempEye, varyBiNormal ); 
 varyEyeVec.z = dot( tempEye, varyNormal ); 
 
 vec3 tempLight = varyLight;
 varyLight.x = dot( tempLight, varyTangent ); 
 varyLight.y = dot( tempLight, varyBiNormal ); 
 varyLight.z = dot( tempLight, varyNormal ); 
 
}