attribute vec3 normals;
attribute vec3 tangent;
attribute vec2 texCoord1;
varying vec2 texCoord;


varying vec3 varyEyeVec;
varying vec3 varyTangent;
varying vec3 varyBiNormal;
varying vec3 varyNormal;
varying vec3 varyLight;

uniform float anim;

void main()
{

 texCoord = texCoord1;
 vec4 possy = gl_Vertex;

 //transform along normal
 float anim2 = anim*4.0;
 anim2 = anim2 - 8319.0*(ceil(anim2/8319.0)-1.0);
 float lengthFromAnim = abs(anim2 - texCoord.y )/8319.0;
 //lengthFromAnim = 1.0 - lengthFromAnim;
 float at2 = 1.0-lengthFromAnim;
 float power=pow(abs(at2),18.0);
 power*=10.1;
 power*=power;
 //power = clamp(power,1.0,100.0);
 possy.xyz+=normalize(normals)*(power);
 float radius = length(possy.xyz)/500.0;
 radius = pow(radius,3.0);
 possy.x+= sin(anim*0.01 +texCoord.y*0.01)*radius;
 possy.y+= sin(anim*0.01 +texCoord.y*0.01)*radius;
 possy.z+= cos(anim*0.01 +texCoord.y*0.01)*radius;

 gl_Position = gl_ModelViewProjectionMatrix * possy;
 
 varyEyeVec = vec3(gl_ModelViewMatrix*possy);
 varyNormal = normalize(gl_NormalMatrix*normals);
 varyTangent = normalize(gl_NormalMatrix*tangent);
 varyBiNormal = normalize(cross(varyNormal,varyTangent));
 
 varyLight = -varyEyeVec;
 
 //make eyeVec in tangent space.
 vec3 tempEye = varyEyeVec;
 varyEyeVec.x = dot( tempEye, varyTangent ); 
 varyEyeVec.y = dot( tempEye, varyBiNormal ); 
 varyEyeVec.z = dot( tempEye, varyNormal ); 
 
 vec3 tempLight = varyLight;
 varyLight.x = dot( tempLight, varyTangent ); 
 varyLight.y = dot( tempLight, varyBiNormal ); 
 varyLight.z = dot( tempLight, varyNormal ); 
 
}