varying vec2 texCoord;
uniform sampler2D baseMap;
uniform sampler2D noiseMap;
uniform samplerCube envMap;

varying vec3 varyEyeVec;
varying vec3 varyTangent;
varying vec3 varyBiNormal;
varying vec3 varyNormal;
varying vec3 varyLight;

uniform float anim;
uniform float glow;



void main()
{
	if(anim < texCoord.y)
		discard;//*/

	vec4 col = texture2D(baseMap,vec2(texCoord.x*0.2,texCoord.y*0.1));
	vec3 bump = texture2D(noiseMap,varyEyeVec.xy*0.007).xyz;
	bump*=0.5;
	bump+=vec3(0.5);
	float lightRec = max(dot(normalize(varyEyeVec),normalize(bump)),0.2);
	vec3 envCol = textureCube(envMap,reflect(normalize(varyEyeVec),normalize(bump))).rgb;
	
	
	float attenuation = 1.0/(length(varyEyeVec)*0.01);
	float anim2 = anim*3.5 + 400.0;
	anim2 = anim2 - 8319.0*(ceil(anim2/8319.0)-1.0);
	float lengthFromAnim = abs(anim2 - texCoord.y )/8319.0;
	//lengthFromAnim = 1.0 - lengthFromAnim;
	float at2 = 1.0-lengthFromAnim;
	at2=pow(abs(at2),26.0);
	at2*=0.8;
	
	vec4 finCol = lightRec*(vec4(envCol,0.0)) + vec4(at2,at2,at2,0.0) + vec4(vec3(attenuation),0.0);

	gl_FragColor = finCol;
}