varying vec2 texCoord;
uniform sampler2D baseMap;
uniform sampler2D noiseMap;
uniform sampler2D skyMap;
uniform samplerCube envMap;

uniform float anim;
varying vec3 norm;
varying vec3 eyeVec;
varying vec3 lightVec;
uniform float anim2;
void main()
{
vec3 noiseSample = texture2D(noiseMap,vec2(texCoord.x*13.1,texCoord.y*23.01)).rgb * 2.0 - vec3(1.0);
vec3 bumpNorm = norm;
bumpNorm = normalize(noiseSample);
vec3 lightVec2=normalize(lightVec);
float lightRec = max(dot(bumpNorm,lightVec2),0.2);
float spec = clamp(dot(reflect(normalize(eyeVec),bumpNorm),normalize(-lightVec2)),0.0,1.0);
spec = pow(spec,90.0);
float dist = length(eyeVec)/50.0;
spec = spec*(1.0/pow(dist,0.3));
vec3 envCol = textureCube(envMap,reflect(normalize(eyeVec),bumpNorm)).rgb;
vec4 col = texture2D(baseMap,vec2(texCoord.x+anim*1.2,texCoord.y+anim*1.3));
vec2 texCrd = vec2(1.0-texCoord.y,texCoord.x + anim2)*14.0;
float alphaMod = sin(anim*3.4 + texCrd.y)*0.5 + 0.5;
vec4 skyRef = texture2D(skyMap,texCrd);
skyRef.a*=alphaMod;
skyRef.a/=dist;
envCol = vec3(envCol.r/3.0 + envCol.g/3.0 + envCol.b/3.0);
gl_FragColor = vec4((envCol*vec3(0.7,0.7,0.8)) + skyRef.rgb*skyRef.a,0.70) ;

}

