float4x4 matWorldViewProjection;
float4x4 matWorldView;
float4x4 matWorld; 

float FogEnd = 400.f;
float FogStart = 0.f; 

float3 CameraPosition = {100.f, 1.f, 1.f};
float3 LightPosition  = {100.f, 0.f, 0.f};

texture tex0; //n
texture tex1;
 

samplerCUBE lightmap = 
sampler_state
{
	texture = (tex1);
	AddressU = Wrap;
	AddressV = Wrap; 
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear; 
};

sampler2D normalmap = 
sampler_state 
{
	texture = (tex0);
	AddressU = Wrap;
	AddressV = Wrap; 
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear; 
};


void vs_wood(in float4 ipos : POSITION,
			 in float3 inorm : NORMAL,
			 in float2 itex : TEXCOORD0,
			 out float4 opos : POSITION,
			 out float3 onorm : TEXCOORD0,
			 out float2 otex : TEXCOORD1,
			 out float3 lightvec : TEXCOORD2,
			 out float  fog : TEXCOORD3)
{
	opos = mul(ipos, matWorldViewProjection);
	onorm = normalize(mul(inorm, matWorld));
	otex = itex; 
	
	float3 yo = mul(float4(ipos.xyz, 1.f), matWorld);
	fog =  1.f-clamp( (length(CameraPosition-(yo))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
	lightvec = normalize(LightPosition - yo); 
}

float4 ps_wood(in float3 normal : TEXCOORD0,
			   in float2 tex : TEXCOORD1,
			   in float3 lightvec : TEXCOORD2,
			   in float fog : TEXCOORD3) : COLOR0
{
	//return float4(1.f, 0.f, 0.f, 0.f);
	
	normal = normalize(normal+tex2D(normalmap, tex));
	
	float dif = dot(normal, lightvec);
	
	return tex2D(normalmap, tex);
	
	return float4(1.f, 1.f, 1.f, 1.f)*dif;
	return float4(lightvec.rgb, 1.f)*fog;
	return float4(normal.xyz, 1.f)*fog;
}

technique wood
{
	pass base
	{
		VertexShader = compile vs_2_0 vs_wood();
		PixelShader  = compile ps_2_0 ps_wood();
	}
}