float4x4 matWorldViewProjection;
texture tex1;

sampler2D base = sampler_state
{
	texture = (tex1);
	AddressV = Wrap;
	AddressU = Wrap;
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
};

void vs_floor(in float4 pos : POSITION,
			  in float2 tex : TEXCOORD0,
			  out float4 opos : POSITION,
			  out float2 otex : TEXCOORD0)
{
	opos = mul(pos, matWorldViewProjection);
	otex = tex;
}

float4 ps_floor(in float2 tex : TEXCOORD0) : COLOR0
{
	return tex2D(base, tex);//*ndotl;
};

technique _floor
{
	pass base
	{
		VertexShader = compile vs_2_0 vs_floor();
		PixelShader  = compile ps_2_0 ps_floor();
	}	
}
