float4x4 matWorldViewProjection;
float4x4 matWorldView;
float4x4 matWorld;
float4x4 matView;

float3 Light = {1.f, 1.f, 1.f};
float3 CameraPosition = {1.f, 1.f, 1.f};
float treshold = 3.0f;
float FogStart = 0.f;
float FogEnd  = 300.f;


texture tex1;
sampler2D env = 
sampler_state
{
	texture = (tex1);
	AddressU = Wrap;
	AddressV = Wrap;
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear; 
};

void vs_cave(in float4 ipos : POSITION,
			 in float3 inorm : NORMAL,
			 out float4 opos : POSITION,
			 out float3 onorm : TEXCOORD0,
			 out float3 ovec : TEXCOORD1,
			 out float  fog : TEXCOORD2)
{
	opos = mul(ipos, matWorldViewProjection);
	onorm = normalize(mul(inorm, matWorld));
//	ovec = normalize((mul(ipos, matWorld)));
	ovec.x = 0.f;
	ovec.y = 0.f;
	ovec.z = 1.f;
	fog = 1.f-clamp( (length(CameraPosition-mul(ipos, matWorld))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
};

float4 ps_cave(in float3 onorm : TEXCOORD0,
			   in float3 ovec  : TEXCOORD1,
			   in float fog : TEXCOORD2) : COLOR0
{
//	return float4(ovec.xyz, 1.f);
//	onorm.z = 1.f-onorm.z;
//	onorm.z *= .01f;
//	onorm.z *= 10.1f;
//	return float4(onorm.z,onorm.z,onorm.z, 1.f);
//	return float4(ovec.xyz, 1.f);
//	return float4(onorm.xyz, 1.f);

	//return tex2D(env, onorm.yz); //yz

	
	//return tex2D(env, float2( (dif*.5f)+.5f, (dif*.5f)+.5f) );
	
	//float dif = abs(length(onorm.z));
//	float dif = 1.f-((dot(onorm, ovec)*1.f)+.2f)*2.f;
	float dif = dot(onorm, ovec);
	dif =  1.f-clamp(0.f, 1.f, (dif*treshold));
	return float4(dif, dif, dif, 0.f)*fog;
}

technique cave
{
	pass stanard
	{
		VertexShader = compile vs_2_0 vs_cave();
		PixelShader  = compile ps_2_0 ps_cave();
	}
}