#include "sharedfx.h"

shared float4	vTexelSize;
shared float4	vPixelSize;

shared float4	vRandomSphere[128];

texture tTexture;
texture tTexture2;
texture tTexture3;
sampler sTextureSamplerPoint = 
sampler_state
{
    Texture = <tTexture>;
    MipFilter = POINT;
    MinFilter = POINT;
    MagFilter = POINT;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

sampler sTextureSamplerLinear = 
sampler_state
{
    Texture = <tTexture>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

sampler sTextureSamplerLinear2 = 
sampler_state
{
    Texture = <tTexture2>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

sampler sTextureSamplerLinear3 = 
sampler_state
{
    Texture = <tTexture3>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

texture tVolume;
sampler sVolumeSamplerLinear = 
sampler_state
{
    Texture = <tVolume>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = WRAP;
    AddressV = WRAP;
    AddressW = WRAP;
};

texture tRandomPlanes;
sampler sRandomPlanesSamplerPoint = 
sampler_state
{
    Texture = <tRandomPlanes>;
    MipFilter = POINT;
    MinFilter = POINT;
    MagFilter = POINT;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

void SpriteVS(			float4 inPosition : POSITION,
						float2 inUV : TEXCOORD0,
						out float4 outPosition : POSITION,
						out float2 outUV : TEXCOORD0 )
{
	outPosition = inPosition;
	outUV = inUV + vTexelSize.zw;
}

float4 SpritePS( float2 inUV : TEXCOORD0 ) : COLOR
{
	return tex2D(sTextureSamplerLinear, inUV)*vConstColour;
}

float4 vZoomerCompositeBias=float4(1.0f, 0.0f, 0.0f, 0.0f);
void ZoomerCompositeVS(			float4 inPosition : POSITION,
						float2 inUV : TEXCOORD0,
						out float4 outPosition : POSITION,
						out float2 outUV : TEXCOORD0,
						out float2 outUVH : TEXCOORD1 )
{
	outPosition = inPosition;
	outUV = inUV + vTexelSize.zw;
	outUVH = inUV + vTexelSize.zw*0.5f;
}

float4 ZoomerCompositePS( float2 inUV : TEXCOORD0 ) : COLOR
{
	float4 vPrev=tex2D(sTextureSamplerLinear, inUV)*vZoomerCompositeBias.x+vZoomerCompositeBias.y;
	float4 vActual=tex2D(sTextureSamplerLinear2, inUV);
	float4 vBloom=tex2D(sTextureSamplerLinear3, inUV);
	float4 vComposite=lerp(vPrev, vBloom+(1.0f-vBloom)*vActual, vConstColour.a);
	vComposite.rgb*=vConstColour.rgb;
	return vComposite*vZoomerCompositeBias.x+vZoomerCompositeBias.y;
}

void AOVS(	float4 inPosition : POSITION,
						float2 inUV : TEXCOORD0,
						out float4 outPosition : POSITION,
						out float2 outUV : TEXCOORD0,
						out float2 outScreenPos : TEXCOORD1,
						out float3 outFrustumPos : TEXCOORD2 )
{
	outPosition = inPosition;
	outUV = inUV + vTexelSize.zw;
	outScreenPos = inPosition.xy;
	outFrustumPos = mul(inPosition, mFrustum);
}

float AOcontrib;
float4 AOPS(			float2 inUV : TEXCOORD0,
						float2 inScreenPos : TEXCOORD1,
						float3 inFrustumPos : TEXCOORD2
 ) : COLOR
{
	float3 vRandomPlane	= tex2D(sRandomPlanesSamplerPoint, inUV).xyz*2.0f-1.0f;
	float fDepth		= tex2D(sTextureSamplerPoint, inUV).r;
	float3 vViewPos		= inFrustumPos.xyz*fDepth;
	float1 fBiasedDepth	= fDepth-0.3f;
	
	float fAO=0;
	for (int i=0;i<5;i++)
	{
		float3 vSpherePointJittered	= reflect(vRandomSphere[i].xyz, vRandomPlane);
		float3 vNewViewPos		= vViewPos +vSpherePointJittered;
		float4 vNewProjPos		= mul(float4(vNewViewPos, 1.0f), mProjBias);

		float vNewDepth			= tex2Dproj(sTextureSamplerPoint, vNewProjPos).r;
		fAO						+= vNewDepth>=fBiasedDepth ? AOcontrib : 0.0f;
	}

	return fAO;
}

float4 ClearAOVS(float4 inPosition : POSITION) : POSITION
{
	return inPosition;
}

float4 ClearAOPS( ) : COLOR
{
	return vConstColour;
}

technique Sprite
{
    pass P0
    {          
        VertexShader = compile vs_2_0 SpriteVS();
        PixelShader  = compile ps_2_0 SpritePS();
		ZEnable = FALSE;
		AlphaBlendEnable = FALSE;
		AlphaTestEnable = FALSE;
    }
}

technique SpriteBlend
{
    pass P0
    {          
        VertexShader = compile vs_2_0 SpriteVS();
        PixelShader  = compile ps_2_0 SpritePS();
		ZEnable = FALSE;
		AlphaBlendEnable = TRUE;
		SrcBlend = SRCALPHA;
		DestBlend = INVSRCALPHA;
		AlphaTestEnable = FALSE;
    }
}

technique SpriteMul
{
    pass P0
    {          
        VertexShader = compile vs_2_0 SpriteVS();
        PixelShader  = compile ps_2_0 SpritePS();
		ZEnable = FALSE;
		AlphaBlendEnable = TRUE;
		SrcBlend = DESTCOLOR;
		DestBlend = ZERO;
		AlphaTestEnable = FALSE;
    }
}

technique SpriteAdd
{
    pass P0
    {          
        VertexShader = compile vs_2_0 SpriteVS();
        PixelShader  = compile ps_2_0 SpritePS();
		ZEnable = FALSE;
		AlphaBlendEnable = TRUE;
		SrcBlend = ONE;
		DestBlend = ONE;
		AlphaTestEnable = FALSE;
    }
}

technique SpriteAddSmooth
{
    pass P0
    {          
        VertexShader = compile vs_2_0 SpriteVS();
        PixelShader  = compile ps_2_0 SpritePS();
		ZEnable = FALSE;
		AlphaBlendEnable = TRUE;
		SrcBlend = ONE;
		DestBlend = INVSRCCOLOR;
		AlphaTestEnable = FALSE;
    }
}

technique AmbientOcclusion
{
    pass P0
    {          
        VertexShader = compile vs_2_0 AOVS();
        PixelShader  = compile ps_2_0 AOPS();
		ZEnable = FALSE;
		AlphaBlendEnable = FALSE;
		AlphaTestEnable = FALSE;
    }
}

technique AmbientOcclusionAdd
{
    pass P0
    {          
        VertexShader = compile vs_2_0 AOVS();
        PixelShader  = compile ps_2_0 AOPS();
		ZEnable = FALSE;
		AlphaBlendEnable = TRUE;
		SrcBlend = ONE;
		DestBlend = ONE;
		AlphaTestEnable = FALSE;
    }
}

technique ClearAODepth
{
    pass P0
    {          
        VertexShader = compile vs_2_0 ClearAOVS();
        PixelShader  = compile ps_2_0 ClearAOPS();
		ZEnable = TRUE;
		ZWriteEnable = FALSE;
		ZFunc = LESS;
		AlphaBlendEnable = FALSE;
		AlphaTestEnable = FALSE;
    }
}

float4 blurSize;
void BlurVS(			float4 inPosition : POSITION,
						float2 inUV : TEXCOORD0,
						out float4 outPosition : POSITION,
						out float2 outUV[7] : TEXCOORD0 )
{
	outPosition = inPosition;
	outUV[0] = inUV + vTexelSize.zw;
	outUV[1] = inUV + vTexelSize.zw - vTexelSize.xy*5.5f*blurSize;
	outUV[2] = inUV + vTexelSize.zw - vTexelSize.xy*3.5f*blurSize;
	outUV[3] = inUV + vTexelSize.zw - vTexelSize.xy*1.5f*blurSize;
	outUV[4] = inUV + vTexelSize.zw + vTexelSize.xy*1.5f*blurSize;
	outUV[5] = inUV + vTexelSize.zw + vTexelSize.xy*3.5f*blurSize;
	outUV[6] = inUV + vTexelSize.zw + vTexelSize.xy*5.5f*blurSize;
}

float4 BlurPS( float2 inUV[7] : TEXCOORD0 ) : COLOR
{
	float4 vColour=0;
	for (int i=0;i<7;i++)
	{
		vColour+=tex2D(sTextureSamplerLinear, inUV[i]);
	}
	return vColour*vConstColour;
}

technique Blur
{
    pass P0
    {          
        VertexShader = compile vs_2_0 BlurVS();
        PixelShader  = compile ps_2_0 BlurPS();
		ZEnable = FALSE;
		AlphaBlendEnable = FALSE;
		AlphaTestEnable = FALSE;
    }
}

float blurThreshold;
float4 BlurExtractPS( float2 inUV : TEXCOORD0 ) : COLOR
{
	float4 vColour=tex2D(sTextureSamplerLinear, inUV);
//	float luminance=dot(vColour.rgb, float3(0.3f, 0.59f, 0.11f));
//	vColour=(luminance>=blurThreshold) ? vColour : 0;
//	return vColour;
	return pow(vColour, blurThreshold);
}

technique BlurExtract
{
    pass P0
    {          
        VertexShader = compile vs_2_0 SpriteVS();
        PixelShader  = compile ps_2_0 BlurExtractPS();
		ZEnable = FALSE;
		AlphaBlendEnable = FALSE;
		AlphaTestEnable = FALSE;
    }
}


void ConstColourVS(			float4 inPosition : POSITION,
						out float4 outPosition : POSITION )
{
	outPosition = inPosition;
}

float4 ConstColourPS( ) : COLOR
{
	return vConstColour;
}


technique ConstColourDoubler
{
    pass P0
    {          
        VertexShader = compile vs_2_0 ConstColourVS();
        PixelShader  = compile ps_2_0 ConstColourPS();
		ZEnable = FALSE;
		AlphaBlendEnable = TRUE;
		SrcBlend = DESTCOLOR;
		DestBlend = ONE;
		AlphaTestEnable = FALSE;
    }
}

technique ZoomerComposite
{
    pass P0
    {          
        VertexShader = compile vs_2_0 ZoomerCompositeVS();
        PixelShader  = compile ps_2_0 ZoomerCompositePS();
		ZEnable = FALSE;
		AlphaBlendEnable = FALSE;
		AlphaTestEnable = FALSE;
    }
}

void VolumeFogVS(	float4 inPosition : POSITION,
						float2 inUV : TEXCOORD0,
						out float4 outPosition : POSITION,
						out float2 outUV : TEXCOORD0,
						out float2 outScreenPos : TEXCOORD1,
						out float3 outFrustumPos : TEXCOORD2,
						out float3 outWorldFrustumPos : TEXCOORD3 )
{
	outPosition = inPosition;
	outUV = inUV + vTexelSize.zw;
	outScreenPos = inPosition.xy;
	outFrustumPos = mul(inPosition, mFrustum);
	outWorldFrustumPos = mul(outFrustumPos, (float3x3)mInvView);
}

float4 VolumeFogPS(			float2 inUV : TEXCOORD0,
						float2 inScreenPos : TEXCOORD1,
						float3 inFrustumPosx : TEXCOORD2,
						float3 inWorldFrustumPos : TEXCOORD3
 ) : COLOR
{
	inWorldFrustumPos=normalize(inWorldFrustumPos);
	float3 vFogCoord = vEyePos*0.05f + inWorldFrustumPos;
	float fTexel = tex3D(sVolumeSamplerLinear, vFogCoord).r;
	float fDepth = tex2D(sTextureSamplerPoint, inUV).r;
	float fAlpha = saturate(fDepth*0.1f);

	return vConstColour*float4(fTexel, fTexel, fTexel, fAlpha);
}

technique VolumeFog
{
    pass P0
    {          
        VertexShader = compile vs_2_0 VolumeFogVS();
        PixelShader  = compile ps_2_0 VolumeFogPS();
		ZEnable = FALSE;
		AlphaBlendEnable = TRUE;
		SrcBlend = SRCALPHA;
		DestBlend = INVSRCALPHA;
		AlphaTestEnable = FALSE;
    }
}
