struct VS_OUTPUT
{
  float4 Position: POSITION;
  float3 Tex0:     TEXCOORD0;
};

sampler Sampler = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

float V_Alpha : ALPHA;
float V_Var1 : VAR1;
float V_Var2 : VAR2;
float V_Var3 : VAR3;
float V_Var4 : VAR4;
float V_Var5 : VAR5;
float V_Var6 : VAR6;
float V_Var7 : VAR7;

float4 PS(VS_OUTPUT In) : COLOR0
{
  float4 color = tex2D(Sampler, In.Tex0.xy);
  float a=color.a;

  float4 hued=(float4(cos((V_Var6+0.000)*3.14*4),
				cos((V_Var6+0.333)*3.14*4),
				cos((V_Var6+0.666)*3.14*4),
				0)+1)*
				V_Var5*0.5;
  color = pow(color*(1-V_Var3*0.75-hued*0.5)+hued+V_Var3,1+V_Var2*V_Var2*80);
  float sat=(color.r+color.g+color.b)*0.333;
  color=color*(1-V_Var7)+sat*V_Var7; 

  color.a = V_Alpha * a;
  return color;
}

technique Colorize
{
  pass PassColorize
  {
    PixelShader = compile ps_2_0 PS();
  }
}
