// Levels.fx
//
// Based on
// VVVV Levels.fx by mtallen
//
// a "levels" oriented pixel shader
// http://pippin.gimp.org/image_processing/chap_point.html has a bunch of the
// gimps algorithms for this.

struct VS_OUTPUT
{
  float4 Position: POSITION;
  float3 Tex0:     TEXCOORD0;
};

sampler Sampler = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};


float V_Alpha : ALPHA;
float blackPoint : VAR1;
float whitePoint : VAR2;
float grayPoint  : VAR3;
float blackOffset: VAR4;
float whiteOffset: VAR5;

float levels(float value)
{
  blackPoint = clamp(blackPoint, blackPoint, whitePoint - 0.008);
  whitePoint = clamp(whitePoint, blackPoint + 0.008, whitePoint);
  grayPoint  = clamp(grayPoint, blackPoint + 0.004, whitePoint - 0.004);
  value      = saturate((value - blackPoint) / (whitePoint - blackPoint));
  value      = pow(value, grayPoint);
  return value * (whiteOffset - blackOffset) + blackOffset;
}

float4 PS(VS_OUTPUT In) : COLOR0
{
  float4 col = tex2D(Sampler, In.Tex0);
  col.r = levels(col.r);
  col.g = levels(col.g);
  col.b = levels(col.b);
  col.a = V_Alpha;
  return col;
}

technique Colorize
{
  pass PassColorize
  {
    PixelShader = compile ps_2_0 PS();
  }
}
