/*
	mIRC API
	--------------------------
	Author:		Str3iber
	Version:	1.6
	Contact:	str3iber@gmx.de
	--------------------------
	Comment:	Used to evaluate commands etc.
				Also usefull to work with the mIRC MDI
*/

#include "mirc.h"

mIRCApi api;

void mircApiInit ( HWND mWnd )
{
	api.hFileMap	= CreateFileMapping ( INVALID_HANDLE_VALUE, 0, PAGE_READWRITE, 0, 4096, "mIRC" );
	api.mData		= (LPSTR) MapViewOfFile ( api.hFileMap, FILE_MAP_ALL_ACCESS, 0, 0, 0 );

	api.mainWnd		= mWnd;

	api.procMirc	= (WNDPROC) SetWindowLong ( api.mainWnd, GWL_WNDPROC, (LONG) mircApiMainProc );

	EnumChildWindows ( 

		api.mainWnd,
		(WNDENUMPROC) mircApiMDIProc,
		NULL

		);

	api.procChild	= (WNDPROC) SetWindowLong ( api.mdiWnd, GWL_WNDPROC, (LONG) mircApiProc );
}
void mircApiClose ()
{
	SetWindowLong ( api.mainWnd, GWL_WNDPROC, (LONG) api.procMirc );
	SetWindowLong ( api.mdiWnd, GWL_WNDPROC, (LONG) api.procChild );

	UnmapViewOfFile ( api.mData );
	CloseHandle ( api.hFileMap );
}
bool mircApiCommand ( LPSTR cmd )
{
	wsprintf ( api.mData, cmd );
	return ( SendMessage(api.mainWnd, WM_USER + 200, 1, 0) != 0 );
}
LPSTR mircApiEvaluate ( LPSTR cmd )
{
	wsprintf ( api.mData, cmd );
	SendMessage (api.mainWnd, WM_USER + 201, 1, 0 );
	return api.mData;
}
int mircApiGetInt ( LPSTR cmd )
{
	LPSTR eCmd;
	eCmd = mircApiEvaluate ( cmd );

	return atoi ( eCmd );
}
BOOL CALLBACK mircApiMDIProc ( HWND hWnd,LPARAM lp )
{
	char chrClass[100];

	GetClassName ( hWnd, chrClass, 100 );

	if (!lstrcmpi( chrClass,"MDIClient"))
		api.mdiWnd = hWnd;

	return TRUE;
}
LRESULT CALLBACK mircApiProc ( HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam )
{
	switch(uMsg)
	{	
		case WM_CLOSE: 
			SetWindowLong ( api.mdiWnd, GWL_WNDPROC, (LONG)api.procChild );
			PostMessage (hWnd, uMsg, 0, 0 );
			return 0;
	}
	return CallWindowProc ( api.procChild, hWnd, uMsg, wParam, lParam );

}
LRESULT CALLBACK mircApiMainProc ( HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam )
{
	switch(uMsg)
	{
		case WM_CLOSE: 
			SetWindowLong ( api.mainWnd , GWL_WNDPROC, (LONG) api.procMirc );
			PostMessage ( hWnd, uMsg, 0, 0 );
			return 0;
	}
	return CallWindowProc ( api.procMirc, hWnd, uMsg, wParam, lParam );
}