/*
	mIRC Fullscreen DLL
	--------------------------
	Author:		Str3iber
	Version:	1.3
	Contact:	str3iber@gmx.de
	--------------------------
	Comment:	Nothing special, but I like to sit in front of my TV and
				can see whats going on in our priv. channel for example.

				This DLL might also be fun with games for mIRC :o)
*/

#include "main.h"

HWND hWindow		= NULL;
BOOL bInFullScreen	= FALSE;
BOOL bIsChild		= FALSE;
BOOL bIsMouseHidden	= FALSE;

LONG lStyles		= NULL;
LONG lExStyles		= NULL;

HRGN hRegion		= NULL;

int	iCustomWidth	= FS_SMALL_WIDTH;
int iCustomHeight	= FS_SMALL_HEIGHT;
int iCustomBits		= FS_BPS;
int iCustomFreq		= FS_FREQUENCY;

COLORREF clrTransparent	= 0;
COLORREF clrTolerance	= 0x101010;

extern "C" void WINAPI LoadDll ( LOADINFO *loadInfo )
{
	mircApiInit ( loadInfo->mHwnd );
	loadInfo->mKeep = true;

	return;
}

extern "C" int WINAPI UnloadDll ( int timeout )
{
	if ( !timeout )
	{
		mircApiClose ();
		return MIRC_RET_CONTINUE;
	}
	return MIRC_RET_HALT;
}

MIRC_FUNCTION ( SetWidth )
{
	iCustomWidth = atoi ( data );
	return MIRC_RET_CONTINUE;
}

MIRC_FUNCTION ( SetHeight )
{
	iCustomHeight = atoi ( data );
	return MIRC_RET_CONTINUE;
}

MIRC_FUNCTION ( SetBits )
{
	iCustomBits = atoi ( data );
	return MIRC_RET_CONTINUE;
}

MIRC_FUNCTION ( SetFrequency )
{
	iCustomFreq = atoi ( data );
	return MIRC_RET_CONTINUE;
}

MIRC_FUNCTION ( SetTransparent )
{
	clrTransparent = atoi ( data );
	return MIRC_RET_CONTINUE;
}

MIRC_FUNCTION ( SetTolerance )
{
	clrTolerance = atoi ( data );
	return MIRC_RET_CONTINUE;
}

MIRC_FUNCTION ( LoadRegion )
{
	HBITMAP hBmp = (HBITMAP) LoadImage ( NULL, data, IMAGE_BITMAP, 0, 0, LR_CREATEDIBSECTION | LR_LOADFROMFILE );

	if ( hBmp )
	{
		hRegion = BitmapToRegion ( hBmp, clrTransparent, clrTolerance );

		if ( hRegion )
			MIRC_RETURN ( MIRC_TRUE );
	}
	MIRC_RETURN ( MIRC_FALSE );
}

MIRC_FUNCTION ( SetRegion )
{
	if (hRegion)
	{
		HWND hWnd = (HWND) atoi ( data );

		if (IsWindow ( hWnd ))
		{
			SetWindowRgn ( hWnd, hRegion, TRUE );

			ShowWindow ( hWnd, SW_SHOW );
			UpdateWindow ( hWnd );
		}

	}
	return MIRC_RET_CONTINUE;
}

MIRC_FUNCTION ( Fullscreen )
{
	// /dll Fullscreen.dll Fullscreen HWND > WIDTH > HEIGHT > BITS > FREQ
	// /dll Fullscreen.dll Fullscreen HWND

	if (strchr(data, '>') != NULL)
	{
		HWND hWnd = (HWND) atoi ( strtok ( data , ">" ) );

		if ((bInFullScreen)||(!IsWindow(hWnd)))
			return MIRC_RET_HALT;

		int iWidth	= atoi ( strtok ( NULL, ">" ) );
		int iHeight	= atoi ( strtok ( NULL, ">" ) );
		int iBits	= atoi ( strtok ( NULL, ">" ) );
		int iFreq	= atoi ( strtok ( NULL, ">" ) );

		SetFullScreen (

			hWnd,
			iWidth,
			iHeight,
			iBits,
			iFreq

		);
	}
	else
	{
		HWND hWnd = (HWND) atoi ( data );
	
		if ((bInFullScreen)||(!IsWindow(hWnd)))
			return MIRC_RET_HALT;

		SetFullScreen (

			hWnd,
			iCustomWidth,
			iCustomHeight,
			iCustomBits,
			iCustomFreq

		);
	}
	return MIRC_RET_CONTINUE;
}

MIRC_FUNCTION ( Fullscreen640x480 )
{
	HWND hWnd = (HWND) atoi ( data );

	if ((bInFullScreen)||(!IsWindow(hWnd)))
		return MIRC_RET_HALT;

	SetFullScreen (

		hWnd,
		FS_SMALL_WIDTH,
		FS_SMALL_HEIGHT,
		FS_BPS,
		FS_FREQUENCY

		);

	return MIRC_RET_CONTINUE;
}

MIRC_FUNCTION ( Fullscreen800x600 )
{
	HWND hWnd = (HWND) atoi ( data );

	if ((bInFullScreen)||(!IsWindow(hWnd)))
		return MIRC_RET_HALT;

	SetFullScreen (

		hWnd,
		FS_LARGE_WIDTH,
		FS_LARGE_HEIGHT,
		FS_BPS,
		FS_FREQUENCY

		);

	return MIRC_RET_CONTINUE;
}

MIRC_FUNCTION ( inFullscreen )
{
	if (bInFullScreen)
	{
		MIRC_RETURN ( MIRC_TRUE );
	}

	MIRC_RETURN ( MIRC_FALSE );
}

MIRC_FUNCTION ( OnTop )
{
	HWND hWnd = (HWND) atoi ( data );

	if (!IsWindow(hWnd))
	{
		if (!IsWindow(hWindow))
		{
			MIRC_RETURN ( MIRC_FALSE );
		}
		else
		{
			hWnd = hWindow;
		}
	}

	if (SetForegroundWindow ( hWnd ))
	{
		MIRC_RETURN ( MIRC_TRUE );
	}
	else
	{
		MIRC_RETURN ( MIRC_FALSE );
	}
}

MIRC_FUNCTION ( Reset )
{
	if (bInFullScreen)
	{
		bInFullScreen = FALSE;
		ResetWindow ( hWindow );
		ChangeDisplaySettings ( 0, 0 );

		return MIRC_RET_CONTINUE;
	}

	return MIRC_RET_HALT;
}

MIRC_FUNCTION ( ShowMouse )
{
	if (bIsMouseHidden)
	{
		ShowCursor ( TRUE );
		bIsMouseHidden = FALSE;
	}
	return MIRC_RET_CONTINUE;
}

MIRC_FUNCTION ( HideMouse )
{
	if (!bIsMouseHidden)
	{
		ShowCursor ( FALSE );
		bIsMouseHidden = TRUE;
	}
	return MIRC_RET_CONTINUE;
}


MIRC_FUNCTION ( DLLInfo )
{
	MessageBox ( mWnd, MIRC_DLLINFO_TEXT, MIRC_DLLINFO_TITLE, MIRC_DLLINFO_BUTTONS );
	return MIRC_RET_CONTINUE;
}

BOOL SetFullScreen ( HWND hWnd, int w, int h, int b, int f )
{
	if (!IsWindow(hWnd))
		return FALSE;

	DEVMODE dmScreen;

	dmScreen.dmSize			= sizeof ( DEVMODE );
	dmScreen.dmDisplayFrequency = f;
	dmScreen.dmBitsPerPel	= b;
	dmScreen.dmPelsWidth	= w;
	dmScreen.dmPelsHeight	= h;

	dmScreen.dmFields		= DM_BITSPERPEL | DM_PELSWIDTH | DM_PELSHEIGHT | DM_DISPLAYFREQUENCY;

    if ( ChangeDisplaySettings( &dmScreen, CDS_FULLSCREEN | CDS_RESET ) != DISP_CHANGE_SUCCESSFUL )
		return FALSE;
	else
	{
		hWindow			= hWnd;
		bInFullScreen	= TRUE;

		bIsChild		= IsChild ( api.mdiWnd, hWnd );

		lStyles			= GetWindowLong ( hWnd, GWL_STYLE );
		lExStyles		= GetWindowLong ( hWnd, GWL_EXSTYLE );

		RemStyles ( hWnd, GWL_STYLE, WS_CAPTION | WS_BORDER | WS_DLGFRAME | DS_FIXEDSYS | DS_SETFONT | DS_MODALFRAME | WS_POPUP | WS_CHILDWINDOW );
		RemStyles ( hWnd, GWL_EXSTYLE, WS_EX_CLIENTEDGE | WS_EX_MDICHILD | WS_EX_STATICEDGE | WS_EX_TOOLWINDOW | WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT );
		
		if (bIsChild)
			SetParent ( hWnd, NULL );

		SetWindowPos ( hWnd, HWND_TOP, 0, 0, w, h, SWP_SHOWWINDOW );
		SetFocus ( hWnd );

		return TRUE;
	}
}

void RemStyles( HWND hWnd, int iParm, long lRemStyles )
{
	LONG _lStyles = GetWindowLong ( hWnd, iParm );
	_lStyles &= ~lRemStyles;
	SetWindowLong ( hWnd, iParm, _lStyles );
}

void AddStyles( HWND hWnd, int iParm, long lAddStyles )
{
	LONG _lStyles = GetWindowLong ( hWnd, iParm );
	_lStyles |= lAddStyles;
	SetWindowLong ( hWnd, iParm, _lStyles );
}

void ResetWindow ( HWND hWnd )
{
	if (IsWindow(hWnd))
	{
		SetWindowLong ( hWnd, GWL_STYLE, lStyles );
		SetWindowLong ( hWnd, GWL_EXSTYLE, lExStyles );

		SetWindowPos ( hWnd, NULL, 0, 0, 0, 0, SWP_FRAMECHANGED | SWP_NOMOVE | SWP_NOSIZE | SWP_NOOWNERZORDER | SWP_NOACTIVATE );

		if (bIsChild)
			SetParent ( hWnd, api.mdiWnd );	
	}
}