var canvas;
var ctx;
var tidrs = 0;
var tidns = 0;
var tidcv = 0;
var time = 0;
var scene = 0;
/*
 *
 */
var gp =
[
    /* x,y,z */
    [0.0,0.0,0.0],
    [1.0,0.0,0.0],
    [0.0,1.0,0.0],
];
var gs = [1.0, 1.0, 1.0];

var ng = 3;

var camera  = [0.0, 0.0, -5.0];
var light   = [0.0, 2.0, -6.0];


var wx1 = -4.0, wx2 = 4.0, wy1 = 3.0, wy2 = -3.0;
var dx, dy, sx, sy;

/*
 *
 */
function vec3Add(v1, v2)
{
    return [v1[0]+v2[0], v1[1]+v2[1], v1[2]+v2[2]];
}

function vec3Sub(v1, v2)
{
    return [v1[0]-v2[0], v1[1]-v2[1], v1[2]-v2[2]];
}

function vec3Mul(v1, v2)
{
    return [v1[0]*v2[0], v1[1]*v2[1], v1[2]*v2[2]];
}

function vec3Dot(v1, v2)
{
    return v1[0]*v2[0] + v1[1]*v2[1] + v1[2]*v2[2];
}

function vec3MulF(v1, f)
{
    return [v1[0]*f, v1[1]*f, v1[2]*f];

}

function vec3Norm(v)
{
    var l = 1.0 / Math.sqrt(v[0]*v[0] + v[1]*v[1] + v[2]*v[2]);
    return [v[0]*l, v[1]*l, v[2]*l];
}

/*
 *
 */
function rand ( n )
{
  return ( Math.floor ( Math.random ( ) * n + 1 ) );
}

/*
 *
 */
function intersectSphere(pos, dir)
{
    var retpos;
    var retnorm= new Array();
    var hit = -1;
    
    var mindist = 99999.0;
    for(i = 0; i < ng; i++)
    {
        var v = vec3Sub(pos, gp[i]);
        var b = -vec3Dot(v, dir);
        var d = b*b - vec3Dot(v, v) + gs[i];
        if(d>0.0)
        {
            d = Math.sqrt(d);
            if(b + d > 0.0)
            {
                var i1 = b - d;
                if(i1 > 0.0 && i1 < mindist)
                {
                    mindist = i1;
                    retpos  = vec3Add(pos, vec3MulF(dir, mindist));
                    retnorm = vec3Sub(retpos, gp[i]);
                    hit = i;
                }
            }
        }
    }
    
    retnorm = vec3Norm(retnorm);
    return [hit, retpos, retnorm];
}

function initRT()
{
    dx = (wx2 - wx1) / width;
    dy = (wy2 - wy1) / height;
}

/*
 *
 */
function updatert()
{
	if(tidrs)
	{
		clearTimeout(tidrs);
	}
    var tbajs = new Date();
    time += tbajs.getSeconds();
    
    gp[0][1] = Math.sin((time));
    gp[0][2] = Math.cos((-time));
    gp[1][0] = Math.sin((time));
    gp[1][2] = Math.cos((time));
    gp[2][1] = Math.sin((-time));
    gp[2][2] = Math.cos((time));
    
    clear();
    
    var pos = camera;
    sy = wy1 + dy; 
    for(y = 0; y < height; y++)
    {
        sx = wx1;
        for(x = 0; x < width; x++)
        {
            var dir = vec3Sub([sx,sy,0.0], pos);
            dir = vec3Norm(dir);
            
            var sr = intersectSphere(pos,dir);
            if(sr[0] > -1)
            {
                var ld = vec3Norm(vec3Sub(light,sr[1]));
                var c = vec3MulF([0.0,255.0,0.0],vec3Dot(ld, sr[2]));
                putpixel(x,y,parseInt(c[0]),parseInt(c[1]),parseInt(c[2]));
            }
            sx += dx;
        }
        sy += dy;
    }
    if(scene <= 1)
    {
        scene = 1;
        tidrs = setTimeout("updatert()", 1);
    }
}

/*
 *
 */
function updatenoise()
{
	if(tidns)
	{
		clearTimeout(tidns);
	}
    var tbajs = new Date();
    
    clear();
    
    for(y = 0; y < height; y++)
    {
        for(x = 0; x < width; x++)
        {
            putpixel(x,y,rand(255),rand(255),rand(255));
        }
    }
    if(scene <= 0)
    {
        scene = 0;
        tidns = setTimeout("updatenoise()", 1);
    }
}

function start()
{
    tidrs = setTimeout("updatert()", 2000);
    tidns = setTimeout("updatenoise()", 1);
}

function stop()
{
	if(tidrs)
	{
		clearTimeout(tidrs);
		tidrs = 0;
	}
	if(tidns)
	{
		clearTimeout(tidrs);
		tidrs = 0;
	}
	if(tidcv)
	{
		clearTimeout(tidrs);
		tidrs = 0;
	}
}

function clear()
{
	ctx.fillStyle = "rgb(0,0,0)";
	ctx.fillRect(0,0,canvas.width, canvas.height);
}

function putpixel(x, y, r, g, b)
{
	ctx.fillStyle = "rgb("+r+","+g+","+b+")";
	ctx.fillRect(x*scale,y*scale,scale,scale);
}

function dispmake(sk)
{
	document.title = "Loading...";
	canvas = document.getElementById("canvas");
	ctx = canvas.getContext("2d");
	scale = sk;
	width = canvas.width / scale;
	height = canvas.height / scale;
	
	for(x = 0; x < width; x++)
	{
		for(y = 0; y < height; y++)
		{
			putpixel(x,y,0,0,0);
		}
	}
    
    initRT();
    
	document.title = "Tusen strlar av bajs.";
}
