
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Gussoh
 */
public class Fasad {

    private LinkedList<Procedure> procedures = new LinkedList<Procedure>();
    private ListIterator<Procedure> procedureIterator = procedures.listIterator();
    private Procedure currentProcedure;
    private List<Class> availableProcedures = new ArrayList<Class>();
    private ArrayList<FasadUpdateListener> updateListeners = new ArrayList<FasadUpdateListener>();
    private ArrayList<LightListener> lightListeners = new ArrayList<LightListener>();
    private int procedureSecondCounter = 0;
    private boolean run = false;

    public Fasad() {
        availableProcedures.add(BinaryClock.class);
        availableProcedures.add(RunningLights.class);
        availableProcedures.add(VerticalKnightrider.class);
        availableProcedures.add(Snake.class);
        //new LightPanel(this);
        new MainFrame(this);
        new ProcedureRunner().start();
        new SecondCounter().start();
    }
    
    /**
     * Array of the lights
     *
     * @param lights
     */
    public void setLights(boolean[][] lights) {
        for (LightListener ll : lightListeners) {
            ll.setLights(lights);
        }
    }

    public void addProcedure(Procedure p) {
        procedureIterator.add(p);
        updated();
    }

    public void start() {
        run = true;
        updated();
    }

    public void stop() {
        run = false;
        updated();
    }

    public boolean isRunning() {
        return run;
    }

    public static void main(String[] args) {
        new Fasad();
    }

    public List<Class> getAvailableProcedures() {
        return availableProcedures;
    }

    public Procedure getCurrentProcedure() {
        return currentProcedure;
    }

    public int getCurrentProcedureIndex() {
        return procedureIterator.nextIndex() - 1;
    }

    public Queue<Procedure> getProcedures() {
        return procedures;
    }

    public void addUpdateListerner(FasadUpdateListener qul) {
        updateListeners.add(qul);
    }

    public void addLightListener(LightListener ll) {
        lightListeners.add(ll);
    }

    public void updated() {
        for (FasadUpdateListener queueUpdateListener : updateListeners) {
            queueUpdateListener.queueUpdated();
        }
    }

    public void nextProcedure() {
        if (procedureIterator.hasNext()) {
            currentProcedure = procedureIterator.next();
            procedureSecondCounter = 0;
            updated();
        } else {
            procedureIterator = procedures.listIterator();
            if (!procedures.isEmpty()) {
                currentProcedure = procedureIterator.next();
                procedureSecondCounter = 0;
                updated();
            }
        }

    }

    private class ProcedureRunner extends Thread {

        @Override
        public void run() {
            System.out.println("starting procedurerunner");

            for (;;) {
                try {
                    Thread.sleep(10);
                    if (currentProcedure == null) {
                        nextProcedure();
                    }

                    if (run && currentProcedure != null) {
                        if (procedureSecondCounter < currentProcedure.getPreferredDuration()) {
                            try {
                                currentProcedure.run();
                            } catch (Exception ex) {
                                Logger.getLogger(Fasad.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        } else {
                            nextProcedure();
                        }
                    } else {
                        try {
                            Thread.sleep(1000);
                        } catch (InterruptedException ex) {
                        }
                    }
                } catch (InterruptedException ex) {
                    Logger.getLogger(Fasad.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private class SecondCounter extends Thread {

        @Override
        public void run() {
            for (;;) {
                try {
                    Thread.sleep(1000);
                    if (run) {
                        procedureSecondCounter++;
                        System.out.println("Procedure: " + currentProcedure + ": counter: " + procedureSecondCounter + " seconds");
                    }
                } catch (InterruptedException ex) {
                }
            }
        }
    }
}
