

import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;

/**
 *
 * @author Gussoh
 */
public class BinaryClock extends Procedure {

    private int lastSecond;
    
    public BinaryClock(Fasad fasad) {
        super(fasad);
    }
    
    @Override
    public String getName() {
        return "Binary Clock";
    }

    @Override
    public String getDescription() {
        return "Shows a binary clock";
    }

    @Override
    public void run() throws Exception {
        Calendar cal = new GregorianCalendar();
        int hour = cal.get(Calendar.HOUR_OF_DAY);
        int minute = cal.get(Calendar.MINUTE);
        int second = cal.get(Calendar.SECOND);
        
        boolean[] hourLine = new boolean[6];
        boolean[] minuteLine = new boolean[6];
        boolean[] secondLine = new boolean[6];
        
        hourLine[5] = (hour & 1) > 0;
        hourLine[4] = (hour & 2) > 0;
        hourLine[3] = (hour & 4) > 0;
        hourLine[2] = (hour & 8) > 0;
        hourLine[1] = (hour & 16) > 0;
        hourLine[0] = (hour & 32) > 0;
         
        minuteLine[5] = (minute & 1) > 0;
        minuteLine[4] = (minute & 2) > 0;
        minuteLine[3] = (minute & 4) > 0;
        minuteLine[2] = (minute & 8) > 0;
        minuteLine[1] = (minute & 16) > 0;
        minuteLine[0] = (minute & 32) > 0;
        
        for (int i = 0; i < secondLine.length; i++) {
            secondLine[i] = second % 2 > 0;
        }
        
        boolean[][] array = new boolean[3][6];
        array[0] = hourLine;
        array[1] = secondLine;
        array[2] = minuteLine;
        
        if(lastSecond != second) {
            setLights(array);
        }
        
        lastSecond = second;
    }

    @Override
    public int getPreferredDuration() {
        return 20;
    }

}
