varying vec3 Normal;
varying vec2 Texcoord;
varying vec3 LightDirection;

uniform float time;

void main( void )
{
   vec4 lightDiffuse = gl_LightSource[0].diffuse.y;

   vec3  normal         = normalize( Normal );
   vec3  lightDirection = normalize( LightDirection );
   float nDotL          = dot( normal, lightDirection ); 

   vec3 color =  nDotL;
   float alpha = clamp(time - Texcoord.x, 0.0, 1.0);

   gl_FragColor = vec4(color.x, color.y, color.z, alpha);
}