
// initialization
#ifndef VIDF
#define LIGHTPOSITION Position
#define LIGHTCOLOR LightColor
#endif


// Engine Parameters
float4x4 mat_Object_to_World : WORLD;
float4x4 mat_World_to_View : VIEW;
float4x4 mat_View_to_Screen : PROJECTION;
float4x4 mat_World_to_Object : WORLDI;
float3 w_cameraPosition : WORLDCAMERAPOSITION;


// Material parameters

float glowIntensity <
	string UIName = "Glow intensity";
	bool VIExport = true;
> = 1.0;

texture glowTex < 
	string UIName = "Glow Map";
	int Texcoord = 0;
	int MapChannel = 1;
	bool VIExport = true;
>;


// Samples

sampler glowSamp = sampler_state{ 
	Texture = (glowTex);
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
};

// Streams

struct VertexInput{
	float4 o_position : POSITION;
	float3 o_normal   : NORMAL;
	float2 tex_Coord0 : TEXCOORD0;
};

struct VertexOutput{
	float4 s_posRast  : POSITION;
	float2 tex_Coord0 : TEXCOORD0;
	float4 w_position : TEXCOORD1;
	float3 w_normal   : TEXCOORD2;
	float4 s_position : TEXCOORD3;
};

// Vertex Shader

VertexOutput VertexShader(VertexInput input){
	VertexOutput output;
	
	// transfom vectors
	float4 w_position = mul(input.o_position, mat_Object_to_World);
	float4 v_position = mul(w_position, mat_World_to_View);
	float4 s_position = mul(v_position, mat_View_to_Screen);
	
	float3 w_normal = normalize( mul(input.o_normal, (float3x3)mat_Object_to_World) );
	
	// write data
	output.s_posRast = s_position;
	output.s_position = s_position;
	output.w_position = w_position;
	output.w_normal = w_normal;
	output.tex_Coord0 = input.tex_Coord0;
	return output;
}

// Pixel Shader


float4 EmissivePixelShader(VertexOutput input):COLOR0{
	float4 col_glowSamp = tex2D(glowSamp, input.tex_Coord0);
	float3 col_final = col_glowSamp;
	
	float i = pow((col_final.r+col_final.g+col_final.b)*0.333, 0.25) * glowIntensity;
	
	return float4(col_final, i);
}


float4 MaxPixelShader(VertexOutput input):COLOR0{
	float4 res = 0;
	res += EmissivePixelShader(input);
	return res;
}


// Techniques

#ifndef VIDF

technique Max{
	pass p0{
		alphablendenable = true;
		srcblend = one;
		destblend = one;
		
		zwriteenable = false;
		
		vertexShader = compile vs_1_1 VertexShader();
		pixelShader = compile ps_2_0 MaxPixelShader();
	}
}

#else

technique VIDF{
	
	pass emissive{
		vertexShader = compile vs_1_1 VertexShader();
		pixelShader = compile ps_2_0 EmissivePixelShader();
		
		alphablendenable = true;
		srcblend = one;
		destblend = one;
		
		zwriteenable = false;
	}
}

#endif
