uniform sampler2D Src;
uniform sampler2D Src2;
uniform float blur_intensity;

varying vec2 texCoord;

float texScaler = 1.0/128.0;
float texOffset = -0.5/128.0;
vec2 gaussFilter[13];

void main(void)
{
   vec4 color = vec4(0.0,0.0,0.0,0.0);
   gaussFilter[0] = vec2(-6.0 * texScaler + texOffset,1.0/4096.0);
   gaussFilter[1] = vec2(-5.0 * texScaler + texOffset,12.0/4096.0);
   gaussFilter[2] = vec2(-4.0 * texScaler + texOffset,66.0/4096.0);
   gaussFilter[3] = vec2(-3.0 * texScaler + texOffset,220.0/4096.0);
   gaussFilter[4] = vec2(-2.0 * texScaler + texOffset,495.0/4096.0);
   gaussFilter[5] = vec2(-1.0 * texScaler + texOffset,792.0/4096.0);
   gaussFilter[6] = vec2(0.0 * texScaler + texOffset,924.0/4096.0);
   gaussFilter[7] = vec2(1.0 * texScaler + texOffset,792.0/4096.0);
   gaussFilter[8] = vec2(2.0 * texScaler + texOffset,495.0/4096.0);
   gaussFilter[9] = vec2(3.0 * texScaler + texOffset,220.0/4096.0);
   gaussFilter[10] = vec2(4.0 * texScaler + texOffset,66.0/4096.0);
   gaussFilter[11] = vec2(5.0 * texScaler + texOffset,12.0/4096.0);
   gaussFilter[12] = vec2(6.0 * texScaler + texOffset,1.0/4096.0);
   int i;
   for (i=0;i<13;i++)
   { // * texScaler + texOffset
      color += texture2D(Src,vec2(texCoord.x + gaussFilter[i].x, texCoord.y)) * gaussFilter[i].y;
   }
   color.a *= 2.0;
   
   vec4 base = texture2D(Src2, texCoord);
   
   gl_FragColor = color * blur_intensity + base * (1.0 - blur_intensity) + base;
}