uniform sampler2D Texture0;
uniform float intensity;

vec4 filter_blur(sampler2D blurtex, vec2 vTexCoord, float blur_factor)
{
   float fSampleModificaton = 0.01920;
   vec2 samples00 = vec2(-0.326212, -0.405805);
   vec2 samples01 = vec2(-0.840144, -0.073580);
   vec2 samples02 = vec2(-0.695914,  0.457137);
   vec2 samples03 = vec2(-0.203345,  0.620716);
   vec2 samples04 = vec2( 0.962340, -0.194983);
   vec2 samples05 = vec2( 0.473434, -0.480026);
   vec2 samples06 = vec2( 0.519456,  0.767022);
   vec2 samples07 = vec2( 0.185461, -0.893124);
   vec2 samples08 = vec2( 0.507431,  0.064425);
   vec2 samples09 = vec2( 0.896420,  0.412458);
   vec2 samples10 = vec2(-0.321940, -0.932615);
   vec2 samples11 = vec2(-0.791559, -0.597705);

   vec2 newCoord;
   vec4 sum = texture2D(blurtex, vTexCoord);
   vec4 col = sum;

     newCoord = vTexCoord + fSampleModificaton * samples00;
   sum += texture2D(blurtex, newCoord);

   newCoord = vTexCoord + fSampleModificaton * samples01;
   sum += texture2D(blurtex, newCoord);

   newCoord = vTexCoord + fSampleModificaton * samples02;
   sum += texture2D(blurtex, newCoord);

   newCoord = vTexCoord + fSampleModificaton * samples03;
   sum += texture2D(blurtex, newCoord);
   
   newCoord = vTexCoord + fSampleModificaton * samples04;
   sum += texture2D(blurtex, newCoord);

   newCoord = vTexCoord + fSampleModificaton * samples05;
   sum += texture2D(blurtex, newCoord);

   newCoord = vTexCoord + fSampleModificaton * samples06;
   sum += texture2D(blurtex, newCoord);

   newCoord = vTexCoord + fSampleModificaton * samples07;
   sum += texture2D(blurtex, newCoord);

   newCoord = vTexCoord + fSampleModificaton * samples08;
   sum += texture2D(blurtex, newCoord);
   
   newCoord = vTexCoord + fSampleModificaton * samples09;
   sum += texture2D(blurtex, newCoord);

   newCoord = vTexCoord + fSampleModificaton * samples10;
   sum += texture2D(blurtex, newCoord);

   newCoord = vTexCoord + fSampleModificaton * samples11;
   sum += texture2D(blurtex, newCoord);

   sum /= 13.0;

   vec4 final_color = sum * blur_factor + col * (1.0 - blur_factor); 

   return final_color;
}


void main(void)
{
    vec2 vTexCoord = vec2(gl_TexCoord[0]);
    float clampedint = clamp(intensity, 0.0f, 1.0f);
    vec4 blur_col = filter_blur(Texture0, vTexCoord, intensity) * gl_Color;
    float col = pow((blur_col.r * 0.25 + blur_col.g * 0.65 + blur_col.b * 0.35), 1.2); 
    col = clamp(col, 0.0f, 1.0f);
    gl_FragColor.rgb = vec3(col, col, col);
    gl_FragColor.a = 1.0;
}

