
uniform sampler2D tex;
uniform sampler2D texblur;
uniform float widthDiv;
uniform float heightDiv;

void main() {
	vec2 c = gl_TexCoord[0].xy;
	vec4 rcol = texture2D(tex, c);
	vec4 col = rcol;
	vec4 col1 = texture2D(tex, vec2(c.x-widthDiv, c.y));
	vec4 col2 = texture2D(tex, vec2(c.x-widthDiv, c.y));
	vec4 col3 = texture2D(tex, vec2(c.x, c.y-heightDiv));
	vec4 col4 = texture2D(tex, vec2(c.x, c.y+heightDiv));

	vec4 blurren = rcol*4.0+col1+col2+col3+col4;
	blurren *= 0.125;

	vec4 bluramount = texture2D(texblur, c);
	float amount = max(bluramount.r, max(bluramount.g, bluramount.b))*2.5;
	amount = clamp(amount, 0.0, 1.0);

	gl_FragColor = amount*blurren + (1.0-amount)*rcol;

//gl_FragColor = rcol;
}
