
uniform sampler2D texture;
uniform sampler2D normalTex;

void main() {
	vec3 ldir = normalize(vec3(1.0, 1.0, 2.0));

	vec2 texnew = -1.5+fract(gl_TexCoord[0].xy*8.0)*4.0;
	texnew = clamp(texnew, 0.0, 1.0);

	vec4 col = texture2D(texture, gl_TexCoord[0].xy);
	vec4 col2 = texture2D(texture, texnew);
	vec3 normal = -1.0+2.0*texture2D(normalTex, gl_TexCoord[0].xy*8.0).xzy;

	float light = 0.5+0.5*dot(normal, ldir);
	light = light*light;
	light *= 1.5;

//	vec3 frgb = mix(col, col2, 0.5).rgb;

	vec3 lrgb = light*col.rgb;
	vec3 fcol = lrgb+col2.rgb*col2.rgb;

	gl_FragColor = vec4(fcol*0.25, col.a);

}