
//uniform mat4 ModelWorld4x4;
uniform vec3 cam;

mat3 GetLinearPart( mat4 m )
{
	mat3 result;

	result[0][0] = m[0][0];
	result[0][1] = m[0][1];
	result[0][2] = m[0][2];

	result[1][0] = m[1][0];
	result[1][1] = m[1][1];
	result[1][2] = m[1][2];

	result[2][0] = m[2][0];
	result[2][1] = m[2][1];
	result[2][2] = m[2][2];

	return result;
}

void main()
{
	gl_Position = ftransform();

	// Color map texture coordinates.
	// Increase a little bit the tiling by 2.
	gl_TexCoord[0] = gl_MultiTexCoord0;

	mat3 ModelWorld3x3 = GetLinearPart( gl_ModelViewMatrix );

	// find world space position.
	vec4 WorldPos = gl_ModelViewMatrix *  gl_Vertex;

	// find world space normal.
	vec3 N = normalize( ModelWorld3x3 * gl_Normal );

	// find world space eye vector.
	vec3 E = normalize( WorldPos.xyz - cam.xyz );

	// calculate the reflection vector in world space.
	gl_TexCoord[1].xyz = reflect( E, N );
}