
#define MAX_INSTRUCTIONS 960

//#define EXTRA_LIGHT

uniform sampler2D noiseTex;
uniform sampler2D tex1;
uniform float time;

const float mul = 0.5;	// perlin scale
const float timeMultiplier = 0.0001;
const float crackSize = 0.02;
//const float crackVariation = 0.00001;
const float fadeRange = 0.35;
const float texMul = 1.0/512.0;
const float mid = 0.7;
const float intenseRange = 0.06;

const vec3 fireCol = vec3(0.15, 0.005, 0.005);
const vec3 groundCol = vec3(0.45, 0.25, 0.05);
const vec3 intenseCol = vec3(0.95, 0.35, 0.125);

const vec3 light = vec3(-1.0, 1.0, 0);
const float ambient = 0.10;


	vec3 noiset(vec2 xy) { return texture2D(noiseTex, xy).rgb; }
	vec3 noiset(vec3 xyz) { return texture2D(noiseTex, vec2(xyz.x+xyz.z*17.0, xyz.y+xyz.z*37.0)).rgb; }

	vec3 getCol(vec2 coord, float newTime, float octave) {
		return (//noiset(vec3(coord*octave*0.0078125, newTime))*128.0+
//		       noiset(vec3(coord*octave*0.015625, newTime))*64.0+
//		       noiset(vec3(coord*octave*0.03125, newTime))*32.0+
//		       noiset(vec3(coord*octave*0.0625, newTime))*16.0+
		       noiset(vec3(coord*octave*0.125, newTime))*8.0+
		       noiset(vec3(coord*octave*0.25, newTime))*4.0+
		       noiset(vec3(coord*octave*0.5, newTime))*2.0+
		       noiset(vec3(coord*octave, newTime)));
	}

	float getHeight(vec2 coord, float time) {
		return clamp(getCol(coord, time, mul).r, -255.0, 255.0);
	}

	vec3 getDir(vec2 coord, float newTime) {
		float sx = getHeight(vec2(coord.x-texMul, coord.y), newTime) - getHeight(vec2(coord.x+texMul, coord.y), newTime);
		float sy = getHeight(vec2(coord.x, coord.y-texMul), newTime) - getHeight(vec2(coord.x, coord.y+texMul), newTime);
		return normalize(vec3(sx, 1.0, sy));
	}

	void main() {
		vec2 coord = vec2(gl_TexCoord[0].xy);
		vec3 normLight = normalize(light);

		float newTime = time*timeMultiplier;
		vec3 col = getCol(coord, newTime, mul);

		//col /= 255.0;
		col /= 15.0;

	//	col.g = col.b = col.r;

		float alpha = 1.0;

		float minSize = crackSize;//-crackVariation*abs(sin(coord.x*4.06839+time*17.0*3.14159));
		float maxSize = crackSize;//+crackVariation*abs(sin(coord.y*3.43678+time*13.0*3.14159));

		if (col.r > mid-minSize && col.r < mid+maxSize) {
			alpha = 1.0;
			col = groundCol;

			float light = dot(getDir(coord, newTime), normLight);

			col = intenseCol;//*light;
		}
		else {
/*			float fade = 0.0;
			if (col.r >= mid) {
				alpha = clamp(((col.r-mid)-maxSize)*(2.0/fadeRange), 0.0, 1.0);
///				col = fireCol;
			} else {
				if (col.r > mid-intenseRange) fade = (col.r-(mid-intenseRange))*(1.0/((mid-minSize)-(mid-intenseRange)));
			}*/
			float fade = clamp(1.0-((abs(col.r-mid)-crackSize)*(1.0/intenseRange)), 0.0, 1.0);

#ifdef EXTRA_LIGHT
			col += 0.05*(-1.0+2.0*noiset(coord));
			float light = ambient+(1.0-ambient)*dot(getDir(coord, newTime), normLight);
			col = fade*intenseCol + (1.0-fade)*col.rrr*groundCol*light;
#else
			col = fade*intenseCol + (1.0-fade)*col.rrr*groundCol;
#endif
		}

		gl_FragColor = vec4(col, alpha);
	}

