
uniform sampler2D noiseTex;
uniform float time;

varying vec3 pos;

vec3 noiset(vec2 xy) { return texture2D(noiseTex, xy).rgb; }
vec3 noiset(vec3 xyz) { return texture2D(noiseTex, vec2(xyz.x+xyz.z*17.0, xyz.y+xyz.z*37.0)).rgb; }

vec3 col = vec3(186.0/205.0, 176.0/255.0, 153.0/205.0);

vec3 getCol(vec2 coord, float newTime, float octave) {
/*	return (noiset(vec3(coord*octave*0.0078125, newTime))*128.0+
	       noiset(vec3(coord*octave*0.015625, newTime))*64.0+
	       noiset(vec3(coord*octave*0.03125, newTime))*32.0+
	       noiset(vec3(coord*octave*0.0625, newTime))*16.0+
	       noiset(vec3(coord*octave*0.125, newTime))*8.0+
	       noiset(vec3(coord*octave*0.25, newTime))*4.0+
	       noiset(vec3(coord*octave*0.5, newTime))*2.0+
	       noiset(vec3(coord*octave, newTime)))/255.0;*/
	return (noiset(vec3(coord*octave*0.125, newTime))*8.0+
	       noiset(vec3(coord*octave*0.25, newTime))*4.0+
	       noiset(vec3(coord*octave*0.5, newTime))*2.0+
	       noiset(vec3(coord*octave, newTime)))/15.0;
}

void main() {
	vec3 texcoord = pos;

	float blend = getCol(texcoord.xz, time, 0.1).r;

	float hmul = 1.0-abs(-1.0+texcoord.y*2.0);
	hmul = 1.0-hmul;
	hmul = 1.0-hmul*hmul;
	//hmul *= 0.5+0.5*(noiset(vec3(gl_TexCoord[0].xy, time*0.25)).r/255.0);
	float mid = 0.85;
	float crackSize = 0.25*hmul;
	float intenseRange = 0.05*hmul;

	blend = clamp(1.0-((abs(blend-mid)-crackSize)*(1.0/intenseRange)), 0.0, 1.0);

	float shadow = 1.0;
	if (gl_TexCoord[0].z > 0.5) shadow = 1.0-(0.5-gl_TexCoord[0].z)*2.0;

	//float blend = 0.5+0.5*sin((gl_TexCoord[0].x)*16.0);
/*	blend = 1.0-blend;
	blend = 1.0-blend*blend*blend;*/

	float colmul = getCol(texcoord.xy+vec2(texcoord.z*0.341+time*0.537, texcoord.z*0.4819+time*0.757), time, 0.2).r;

	//gl_FragColor = vec4(col*colmul*shadow, clamp(0.0625*blend, 0.0, 1.0));

	//gl_FragColor = vec4(clamp(pos.xyz, 0.0, 1.0), 1.0);
	gl_FragColor = vec4(1.0, 1.0, 1.0, 0.2);

}
