float4x4 matWorldViewProjection;
float4x4 matLightViewProjection; 

float4 baseColor = {1.f, 0.f, 0.f, 1.f};
float alpha1 = 1.f;
float2 movement = {0.f, 0.f};

texture tex0; //diff
texture tex1; //cover
texture tex2; //shadowmap

sampler2D a = 
sampler_state 
{
	texture = (tex0);
	MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
	AddressV = Wrap; AddressU = Wrap; 
};
sampler2D b = 
sampler_state 
{
	texture = (tex1);
	MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
	AddressV = Wrap; AddressU = Wrap; 
};

sampler2D c = 
sampler_state 
{
	texture = (tex2);
	MipFilter = None; MinFilter = Linear; MagFilter = Linear;
	AddressV = Clamp; AddressU = Clamp; 
};

void vs_main(in float4 ipos : POSITION, 
			    in float2 itex : TEXCOORD0,
			    out float4 opos : POSITION,
			    out float2 otex : TEXCOORD0,
			    out float2 otex1 : TEXCOORD1,
			    out float4 lightpos : TEXCOORD2)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex;
	otex1 = (itex*10.f)+movement;
	lightpos = mul(ipos,  matLightViewProjection); 
}

float4 ps_single(in float2 itex : TEXCOORD0,
				 in float2 itex2 : TEXCOORD1,
				 in float4 lightpos : TEXCOORD2) : COLOR0
{
	float4 base = tex2D(a, itex2)*baseColor;
	float4 cover = tex2D(b, itex);
	
	float2 texLight = .5f * lightpos.xy / lightpos.w + float2(.5f, .5f);
	texLight.y = 1.f - texLight.y;
	
	
	float4 shadow = tex2D(c, texLight);
	return base*cover*alpha1*shadow;
}

technique Div
{
	pass Singel
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_single();
	}
}