float4x4 matWorldViewProjection;
float4x4 matView;
float3 LightPosition = {0.f, 100.f, 0.f};
float anim = 1.f;
texture tex1; //diffuse

sampler2D DiffuseMap = 
sampler_state
{
	texture = (tex1);
	MipFilter = None; MinFilter = Linear; MagFilter = Linear;
	AddressV = Wrap; AddressU = Wrap; 
};

void vs_turret(in float4 ipos : POSITION,
				  in float3 inormal : NORMAL,
				  in float2 itex : TEXCOORD0,
				  out float4 opos : POSITION,
				  out float2 otex : TEXCOORD0,
				  out float3 onormal : TEXCOORD1,
				  out float3 lightdir : TEXCOORD3)
{
	opos = mul(ipos, matWorldViewProjection);
	onormal = mul(inormal, matView);
	otex = itex;
	lightdir = normalize(LightPosition - mul(ipos, matView));
}

float4 ps_turret(in float2 tex : TEXCOORD0, 
								in float3 normal : TEXCOORD1, 
								in float3 lightdir : TEXCOORD3) : COLOR0
{
	//return float4(1.f, 1.f, 1.f, 1.f);
    float NdotL = dot(normal, lightdir);
    float4 Diffuse = tex2D(DiffuseMap, tex)*anim;
	return Diffuse*NdotL;
}

technique Turret
{
	pass DiffuseLight
	{
		VertexShader = compile vs_2_0 vs_turret();
		PixelShader  = compile ps_2_0 ps_turret();
	}
}