float4x4 matProjection;

texture tex0;
float scale = 1.f;
float alpha = 1.f;

sampler2D a = 
sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};

void vs_main(in float4 ipos : POSITION, 
			 in float2 itex : TEXCOORD0,
			 out float4 opos : POSITION,
			 out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matProjection);
	otex = itex;
	itex.y += 1;
	otex.x = ((itex.x-.5f)*scale)+.5f;
	otex.y = ((itex.y-.5f)*scale)+.5f;
};

float4 ps_main(in float2 tex : TEXCOORD0) : COLOR0
{
	return tex2D(a, tex)*alpha;
}

technique flash
{
	pass kuk
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader = compile ps_2_0 ps_main();
	}
}