float4x4 matWorldViewProjection;
float4x4 matLightViewProjection;
float4x4 matView;

float3 LightPosition = {0.f, 100.f, 0.f};
texture tex0;
texture tex1; //pass1
float ambient = 0.f;
float alpha = 1.f;

sampler2D DiffuseMap = 
sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressV = Clamp; AddressU = Clamp;
};
sampler2D PhongMap = 
sampler_state
{
	texture = (tex1);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressV = Clamp; AddressU = Clamp;
};


void vs_main(in float4 ipos : POSITION,
			 in float3 inormal : NORMAL,
			 in float2 itex : TEXCOORD0,
			 out float4 opos : POSITION,
			 out float2 otex : TEXCOORD0,
			 out float3 onormal : TEXCOORD1,
			 out float3 lightv : TEXCOORD2,
			 out float4 lightpos : TEXCOORD3)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex;
	otex.y = 1.f-otex.y;
	onormal = mul(inormal, matView);
	lightv = normalize(LightPosition - mul(ipos, matView));
	lightpos = mul(ipos, matLightViewProjection);
}

float4 ps_diffuselight(in float2 tex : TEXCOORD0,
					   in float3 normal : TEXCOORD1,
					   in float3 lightv : TEXCOORD2) : COLOR0
{
	float4 dLight = dot(normal, lightv);
	float4 dColor = tex2D(DiffuseMap, tex);
	return dColor*dLight+ambient;
}

float4 ps_diffuselightalpha(in float2 tex : TEXCOORD0,
					   in float3 normal : TEXCOORD1,
					   in float3 lightv : TEXCOORD2) : COLOR0
{
	float4 dLight = dot(normal, lightv);
	float4 dColor = tex2D(DiffuseMap, tex);
	float4 pixel = dColor*dLight+ambient;
	pixel.a = alpha;
	return pixel;
}

float4 ps_diffusespotlight(in float2 tex : TEXCOORD0,
					   in float3 normal : TEXCOORD1,
					   in float3 lightv : TEXCOORD2,
					   in float4 lightpos : TEXCOORD3) : COLOR0
{
	float2 spot = .5f*lightpos.xy/lightpos.w + float2(.5f, .5f);
	spot.y = 1.f - spot.y;
	float4 dSpot = tex2D(PhongMap, spot);
	
	float4 dLight = abs(dot(normal, lightv));
	float4 dColor = tex2D(DiffuseMap, tex);
	return (dColor*dLight*dSpot)+ambient;
}

technique Line
{
	pass diffuse
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_diffuselight();
	}
	
	pass diffusespot //rendervally
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_diffusespotlight();
	}
	
	pass diffusealpha  //renderF1
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_diffuselightalpha();
	}
}
						