float4x4 matWorldViewProjection;
float4x4 matView;

float3 CameraPosition = {0.f, 100.f, 0.f};
float3 LightPosition = {00.f, 300.f, 0.f};
float alpha1 = 1.f;
float time; 

texture tex0;
texture tex1;
texture tex2;
sampler2D a = 
sampler_state 
{
	texture = (tex0);
	MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
	AddressV = Wrap; AddressU = Wrap; 
};
sampler2D b = 
sampler_state 
{
	texture = (tex1);
	MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
	AddressV = Wrap; AddressU = Wrap; 
};
sampler2D c = 
sampler_state 
{
	texture = (tex2);
	MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
	AddressV = Wrap; AddressU = Wrap; 
};


void vs_main(in float4 ipos : POSITION, 
			    in float2 itex : TEXCOORD0,
			    in float3 inormal : NORMAL,
			    out float4 opos : POSITION,
			    out float2 otex : TEXCOORD0,
			    out float3 onormal : TEXCOORD1,
			    out float3 viewdir : TEXCOORD2,
			    out float3 lightdir : TEXCOORD3)
{
	float xval = sin(time*ipos.x*.02f);
	float yval = sin(cos(time)*ipos.y*.02f);
	float3 pos = ipos;
	pos.x += .01f*ipos.x*xval;//*ipos.x*yval;
	pos.z += .01f*ipos.z*xval;//*ipos.y*yval;
	pos.y += .01f*ipos.y*xval;//*ipos.z*yval;
	
	opos = mul(float4(pos, 1.f), matWorldViewProjection);
	otex = itex;
	onormal = mul(inormal, matView);
	viewdir = normalize(CameraPosition - mul(ipos, matView));
	lightdir = normalize(LightPosition - mul(ipos, matView));
}

float4 ps_single(in float2 itex : TEXCOORD0,
				 in float3 inormal: TEXCOORD1,
				 in float3 viewdir : TEXCOORD2,
				 in float3 lightdir : TEXCOORD3) : COLOR0
{
	//return float4(inormal, 1.f);
	float diffuse = dot(inormal , lightdir);
//	return diffuse;
	
	float3 kuk = reflect(viewdir, inormal);
	return tex2D(a, kuk)* (diffuse+.7f);
}


technique Div
{
	pass Singel
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_single();
	}
}