float4x4 matWorldViewProjection;

//depth 
float Focus = .7f;
float Eksponent = 1;
float FarClip = 250.f;
float FallOff = 3.f;

//dofblur
float2 pixelstep = {1.f/800.f, 1.f/600.f};

//anim
float anim = 0.f;
float amplitude = 0.f;

texture tex0, tex1;
texture tex2; 

sampler2D a = 
sampler_state
{
	texture = (tex0); 
	MipFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressV = Clamp; AddressU = Clamp;
};
sampler2D depth = 
sampler_state
{
	texture = (tex1);
	MipFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressV = Clamp; AddressU = Clamp;
};

sampler2D b = 
sampler_state
{
	texture = (tex2);
	MipFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressV = Clamp; AddressU = Clamp;
};


void vs_depth(in float4 ipos : POSITION,			 
			 out float4 opos : POSITION, 
			 out float  depth : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	depth = min(1, pow(abs((length(opos)/FarClip)-Focus)*FallOff, Eksponent));
}

float4 ps_depth(in float depth : TEXCOORD0) : COLOR0
{
	return depth;
}


//dof
void vs_dof(in float4 ipos : POSITION,
			    in float2 itex : TEXCOORD0,
			    out float4 opos : POSITION,
			    out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex; 
	otex.y += 1.f;
}

void vs_dofwave(in float4 ipos : POSITION,
			    in float2 itex : TEXCOORD0,
			    out float4 opos : POSITION,
			    out float2 otex : TEXCOORD0,
			    out float  dybde: TEXCOORD1)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex; 
	otex.y += 1.f;
	
	float dx = otex.x-.5f;
	float dy = otex.y-.5f;
	float dist = sqrt(dx*dx+dy*dy);
	float hore = .12f*sin(dist * 10.f - anim);
	otex.x += hore*dx;
	otex.y += hore*dy;
	dybde = abs(hore*dx + hore*dy)*50.f + .5f; 
}


float4 ps_dofsin(in float2 tex : TEXCOORD0) : COLOR0
{
	tex.x += amplitude*sin(tex.y*1000.f * anim);
	float  pixelalpha = (tex2D(depth, tex));
	float4 blur = tex2D(a, tex);
	float4 regular = tex2D(b, tex);
	float4 pixel = blur*pixelalpha + regular*(1.f-pixelalpha);
	return pixel;
	//return float4(pixel.rgb, pixelalpha);
}

float4 ps_dof(in float2 tex : TEXCOORD0) : COLOR0
{
	float  pixelalpha = (tex2D(depth, tex));
	float4 blur = tex2D(a, tex);
	float4 regular = tex2D(b, tex);
	float4 pixel = blur*pixelalpha + regular*(1.f-pixelalpha);
	return pixel;
}

float4 ps_dofdepth(in float2 tex : TEXCOORD0, 
				in float dybde : TEXCOORD1) : COLOR0
{
	float  pixelalpha = (tex2D(depth, tex));
	float4 blur = tex2D(a, tex);
	float4 regular = tex2D(b, tex);
	float4 pixel = blur*pixelalpha + regular*(1.f-pixelalpha);
	return pixel;// * (dybde);
}

float4 ps_dofalpha(in float2 tex : TEXCOORD0, 
				in float dybde : TEXCOORD1) : COLOR0
{
	float  pixelalpha = (tex2D(depth, tex));
	float4 blur = tex2D(a, tex);
	float4 pixel = float4(blur.rgb, pixelalpha);
	return pixel;// * (dybde);
}
	


technique DepthOfField
{
	pass Depth
	{
		VertexShader = compile vs_2_0 vs_depth();
		PixelShader  = compile ps_2_0 ps_depth();
	}
	
	pass Dof
	{
		VertexShader = compile vs_2_0 vs_dof();
		PixelShader  = compile ps_2_0 ps_dof();
	}
	
	pass DofRender1 //(scene1)
	{
		VertexShader = compile vs_2_0 vs_dof();
		PixelShader  = compile ps_2_0 ps_dofsin();
	}
	
	pass DofRender2 //(scene2)
	{
		VertexShader = compile vs_2_0 vs_dofwave();
		PixelShader  = compile ps_2_0 ps_dofdepth();
	}
	
	pass DofAlpha
	{
		VertexShader = compile vs_2_0 vs_dof();
		PixelShader  = compile ps_2_0 ps_dofalpha();
	}
}