float3 lightPos		: Light0;

float4x4 wvpMatrix 	: WorldViewProjection;
float4x4 wMatrix	: World;
float4x4 invMatrix 	: WorldInverseTranspose;
float ColA;

texture normal_0
<
	string UIName = "Normal map";
>;

texture texture_0
<
	string UIName = "Color map";
>;

float3 diffuseColor
<
	string UIName = "Diffuse Color";
> = { 0.8, 0.8, 0.8 };

float3 ambientColor
<
	string UIName = "Ambient Color";
> = { 0.5, 0.5, 0.5 };

sampler normal_0Sampler = 
sampler_state
{
    Texture = <normal_0>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

sampler texture_0Sampler = 
sampler_state
{
    Texture = <texture_0>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

float4x4 boneMatrices[32];

struct VertexInput 
{
	float3 position	: POSITION;
	float3 tangent	: TANGENT;
	float3 binormal	: BINORMAL;
	float2 uvCoord	: TEXCOORD0;
	float4 	BoneWeight 	: TEXCOORD1;
    int4	BoneIndex	: TEXCOORD2;
};

struct VertexOutput
{
	float4 position	: POSITION;
	float2 uvCoord	: TEXCOORD0;
	float3 lightDir	: TEXCOORD1;
};

VertexOutput VS_NormalMap( VertexInput IN )
{
	VertexOutput OUT;
	
	IN.tangent = mul( IN.tangent, invMatrix );
	IN.binormal = mul( IN.binormal, invMatrix );
	
	float4 position = 0;
	float3 newT = 0;
	float3 newB = 0;
	for( int i = 0; i < 4; i++ )
	{
		position += mul( float4( IN.position, 1.0f ), boneMatrices[IN.BoneIndex[i]] ) * IN.BoneWeight[i];
		newT += mul( IN.tangent, boneMatrices[IN.BoneIndex[i]] ) * IN.BoneWeight[i];
		newB += mul( IN.binormal, boneMatrices[IN.BoneIndex[i]] ) * IN.BoneWeight[i];
	}
	float3 newN = cross( newB, newT );
	float3x3 newTBN = float3x3( newT, newB, newN );
	
	OUT.position = mul( position, wvpMatrix );
	OUT.uvCoord = IN.uvCoord;
	float3 wPosition = mul(position, wMatrix);
	OUT.lightDir = (lightPos - wPosition);
	OUT.lightDir = mul( newTBN, OUT.lightDir );

	return OUT;
}

float4 PS_NormalMap( VertexOutput IN ) : COLOR
{   
	float4 nm = tex2D(normal_0Sampler, IN.uvCoord);
	clip( nm.a - ColA + 0.001f );
	IN.lightDir = normalize( IN.lightDir );
	float3 normal = (nm.rgb - 0.5f) * 2.0f;
	normal = mul( normal, wMatrix );
	return float4( (max(0.0f,dot(IN.lightDir,normal)) * diffuseColor + ambientColor )* tex2D(texture_0Sampler,IN.uvCoord).rgb,1.0f);
}

struct VertexInputDepth
{
	float3 position	: POSITION;
	float4 	BoneWeight 	: TEXCOORD1;
    int4	BoneIndex	: TEXCOORD2;
};

struct VertexOutputDepth
{
	float4 position	: POSITION;
};

VertexOutputDepth VS_Depth( VertexInputDepth IN )
{
	VertexOutputDepth OUT;
	float4 position = 0;
	for( int i = 0; i < 4; i++ )
	{
		position += mul( float4( IN.position, 1.0f ), boneMatrices[IN.BoneIndex[i]] ) * IN.BoneWeight[i];
	}
	OUT.position = mul( position, wvpMatrix );
	return OUT;
}
float4 PS_Depth( VertexOutput IN ) : COLOR
{   
	return 0.0f;
}

technique ps20
{
	pass P0
	{          
		VertexShader = compile vs_2_0 VS_NormalMap();
		PixelShader  = compile ps_2_0 PS_NormalMap();
		CullMode = none;
	}
}

technique DepthWrite
{
	pass P0
	{
		VertexShader = compile vs_2_0 VS_Depth();
		PixelShader = compile ps_2_0 PS_Depth();
		
		ColorWriteEnable = 0;
	}
}