float4x4 	wvpMatrix 	: WorldViewProjection;

texture	texture_0
<
	string UIName = "Base texture";
>;

float4		ambientColor
<
	string UIName = "Ambient Material Color";
> = { 1.0f, 1.0f, 1.0f, 1.0f };
float			ColA;

sampler2D texture_0Sampler = sampler_state 
{
    texture = <texture_0>;
    AddressU  = WRAP;        
    AddressV  = WRAP;
    AddressW  = WRAP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

struct VertexInput {
    float3 position	: POSITION;
    float2 uvCoords	: TEXCOORD0;
};

struct VertexOutput {
    float4 position	: POSITION;
    float2 uvCoords	: TEXCOORD0;
};

VertexOutput VS_Ambient(VertexInput IN) {
    VertexOutput OUT;
    
    OUT.position = mul(float4(IN.position,1.0f), wvpMatrix);
	OUT.uvCoords = IN.uvCoords;
    return OUT;
}

float4 PS_Ambient( VertexOutput OUT ) : COLOR
{
	float4 texColor = tex2D( texture_0Sampler, OUT.uvCoords );
	return texColor * float4( ambientColor.rgb, ambientColor.a * ColA );
}

technique ps20
{
    pass p0
    {		
		VertexShader = compile vs_2_0 VS_Ambient();
		PixelShader = compile ps_2_0 PS_Ambient();
		
		AlphaBlendEnable = true;
		SrcBlend = srcAlpha;
		DestBlend = invSrcAlpha;
		
		ZEnable = false;
		ZWriteEnable = false;
    }
}


